/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.CharConstants;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.ReaderException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;

public final class StreamReader {
    private final String name;
    private final Reader stream;
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer = 0;
    private boolean eof;
    private int index = 0;
    private int line = 0;
    private int column = 0;
    private final int bufferSize;
    private final char[] buffer;
    private final boolean useMarks;

    public StreamReader(Reader reader, LoadSettings loadSettings) {
        this(loadSettings, reader);
    }

    public StreamReader(LoadSettings loadSettings, Reader reader) {
        this.name = loadSettings.getLabel();
        this.codePointsWindow = new int[0];
        this.dataLength = 0;
        this.stream = reader;
        this.eof = false;
        this.bufferSize = loadSettings.getBufferSize();
        this.buffer = new char[this.bufferSize];
        this.useMarks = loadSettings.getUseMarks();
    }

    public StreamReader(String string, LoadSettings loadSettings) {
        this(loadSettings, new StringReader(string));
    }

    public StreamReader(LoadSettings loadSettings, String string) {
        this(loadSettings, new StringReader(string));
    }

    public static boolean isPrintable(String string) {
        int n2;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (StreamReader.isPrintable(n2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int n2) {
        return n2 >= 32 && n2 <= 126 || n2 == 9 || n2 == 10 || n2 == 13 || n2 == 133 || n2 >= 160 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    public final Optional<Mark> getMark() {
        if (this.useMarks) {
            return Optional.of(new Mark(this.name, this.index, this.line, this.column, this.codePointsWindow, this.pointer));
        }
        return Optional.empty();
    }

    public final void forward() {
        this.forward(1);
    }

    public final void forward(int n2) {
        for (int i2 = 0; i2 < n2 && this.ensureEnoughData(); ++i2) {
            int n3 = this.codePointsWindow[this.pointer++];
            ++this.index;
            if (CharConstants.LINEBR.has(n3) || n3 == 13 && this.ensureEnoughData() && this.codePointsWindow[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (n3 == 65279) continue;
            ++this.column;
        }
    }

    public final int peek() {
        if (this.ensureEnoughData()) {
            return this.codePointsWindow[this.pointer];
        }
        return 0;
    }

    public final int peek(int n2) {
        if (this.ensureEnoughData(n2)) {
            return this.codePointsWindow[this.pointer + n2];
        }
        return 0;
    }

    public final String prefix(int n2) {
        if (n2 == 0) {
            return "";
        }
        if (this.ensureEnoughData(n2)) {
            return new String(this.codePointsWindow, this.pointer, n2);
        }
        return new String(this.codePointsWindow, this.pointer, Math.min(n2, this.dataLength - this.pointer));
    }

    public final String prefixForward(int n2) {
        String string = this.prefix(n2);
        this.pointer += n2;
        this.index += n2;
        this.column += n2;
        return string;
    }

    private boolean ensureEnoughData() {
        return this.ensureEnoughData(0);
    }

    private boolean ensureEnoughData(int n2) {
        if (!this.eof && this.pointer + n2 >= this.dataLength) {
            this.update();
        }
        return this.pointer + n2 < this.dataLength;
    }

    private void update() {
        block10: {
            try {
                int n2 = this.stream.read(this.buffer, 0, this.bufferSize - 1);
                if (n2 > 0) {
                    int n3 = this.dataLength - this.pointer;
                    this.codePointsWindow = Arrays.copyOfRange(this.codePointsWindow, this.pointer, this.dataLength + n2);
                    if (Character.isHighSurrogate(this.buffer[n2 - 1])) {
                        if (this.stream.read(this.buffer, n2, 1) == -1) {
                            this.eof = true;
                        } else {
                            ++n2;
                        }
                    }
                    Optional<Object> optional = Optional.empty();
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5;
                        this.codePointsWindow[n3] = n5 = Character.codePointAt(this.buffer, n4);
                        if (StreamReader.isPrintable(n5)) {
                            n4 += Character.charCount(n5);
                        } else {
                            optional = Optional.of(n5);
                            n4 = n2;
                        }
                        ++n3;
                    }
                    this.dataLength = n3;
                    this.pointer = 0;
                    if (optional.isPresent()) {
                        throw new ReaderException(this.name, n3 - 1, (Integer)optional.get(), "special characters are not allowed");
                    }
                    break block10;
                }
                this.eof = true;
                return;
            }
            catch (IOException iOException) {
                throw new YamlEngineException(iOException);
            }
        }
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }
}

