/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.route;

import java.util.Objects;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.route.RouteFactory;
import me.extremall.advancedkits.libs.boostedyaml.route.implementation.MultiKeyRoute;
import me.extremall.advancedkits.libs.boostedyaml.route.implementation.SingleKeyRoute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Route {
    @NotNull
    public static Route from(Object ... objectArray) {
        if (Objects.requireNonNull(objectArray, "Route array cannot be null!").length == 0) {
            throw new IllegalArgumentException("Empty routes are not allowed!");
        }
        if (objectArray.length == 1) {
            return new SingleKeyRoute(objectArray[0]);
        }
        return new MultiKeyRoute(objectArray);
    }

    @NotNull
    public static Route from(@NotNull Object object) {
        return new SingleKeyRoute(object);
    }

    @NotNull
    public static Route fromSingleKey(@NotNull Object object) {
        return new SingleKeyRoute(object);
    }

    @NotNull
    public static Route fromString(@NotNull String string) {
        return Route.fromString(string, '.');
    }

    @NotNull
    public static Route fromString(@NotNull String string, char c2) {
        if (string.indexOf(c2) != -1) {
            return new MultiKeyRoute(string.split(Pattern.quote(String.valueOf(c2))));
        }
        return new SingleKeyRoute(string);
    }

    @NotNull
    public static Route fromString(@NotNull String string, @NotNull RouteFactory routeFactory) {
        if (string.indexOf(routeFactory.getSeparator()) != -1) {
            return new MultiKeyRoute(string.split(routeFactory.getEscapedSeparator()));
        }
        return new SingleKeyRoute(string);
    }

    @NotNull
    public static Route addTo(@Nullable Route route, @NotNull Object object) {
        if (route == null) {
            return Route.fromSingleKey(object);
        }
        return route.add(object);
    }

    @NotNull
    public String join(char var1);

    public int length();

    @NotNull
    public Object get(int var1);

    @NotNull
    public Route add(@NotNull Object var1);

    @NotNull
    public Route parent();

    public boolean equals(Object var1);

    public int hashCode();
}

