/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.route.implementation;

import java.util.Arrays;
import java.util.Objects;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import org.jetbrains.annotations.NotNull;

public class MultiKeyRoute
implements Route {
    private final Object[] route;

    public MultiKeyRoute(Object ... objectArray) {
        if (Objects.requireNonNull(objectArray, "Route array cannot be null!").length == 0) {
            throw new IllegalArgumentException("Empty routes are not allowed!");
        }
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray2[i2];
            Objects.requireNonNull(object, "Route cannot contain null keys!");
        }
        this.route = objectArray;
    }

    @Override
    @NotNull
    public String join(char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.length(); ++i2) {
            stringBuilder.append(this.get(i2)).append(i2 + 1 < this.length() ? Character.valueOf(c2) : "");
        }
        return stringBuilder.toString();
    }

    @Override
    public int length() {
        return this.route.length;
    }

    @Override
    @NotNull
    public Object get(int n2) {
        return this.route[n2];
    }

    @Override
    @NotNull
    public Route add(@NotNull Object object) {
        Object[] objectArray = Arrays.copyOf(this.route, this.route.length + 1);
        Object[] objectArray2 = objectArray;
        objectArray[objectArray2.length - 1] = Objects.requireNonNull(object, "Route cannot contain null keys!");
        return new MultiKeyRoute(objectArray2);
    }

    @Override
    @NotNull
    public Route parent() {
        if (this.route.length == 2) {
            return Route.from(this.route[0]);
        }
        return Route.from(Arrays.copyOf(this.route, this.route.length - 1));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Route)) {
            return false;
        }
        object = (Route)object;
        if (this.length() != object.length()) {
            return false;
        }
        if (this.length() == 1 && object.length() == 1) {
            return Objects.equals(this.get(0), object.get(0));
        }
        if (!(object instanceof MultiKeyRoute)) {
            return false;
        }
        return Arrays.equals(this.route, ((MultiKeyRoute)object).route);
    }

    @Override
    public int hashCode() {
        if (this.length() > 1) {
            return Arrays.hashCode(this.route);
        }
        return Objects.hashCode(this.route[0]);
    }

    public String toString() {
        return "MultiKeyRoute{route=" + Arrays.toString(this.route) + '}';
    }
}

