/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.route.implementation;

import java.util.Objects;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import org.jetbrains.annotations.NotNull;

public class SingleKeyRoute
implements Route {
    private final Object key;

    public SingleKeyRoute(@NotNull Object object) {
        this.key = Objects.requireNonNull(object, "Route cannot contain null keys!");
    }

    @Override
    @NotNull
    public String join(char c2) {
        return this.key.toString();
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    @NotNull
    public Object get(int n2) {
        if (n2 != 0) {
            throw new ArrayIndexOutOfBoundsException("Index " + n2 + " for single key route!");
        }
        return this.key;
    }

    @Override
    @NotNull
    public Route parent() {
        throw new IllegalArgumentException("Empty routes are not allowed!");
    }

    @Override
    @NotNull
    public Route add(@NotNull Object object) {
        return Route.from(this.key, Objects.requireNonNull(object, "Route cannot contain null keys!"));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Route)) {
            return false;
        }
        if ((object = (Route)object).length() != 1) {
            return false;
        }
        return Objects.equals(this.key, object.get(0));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "SingleKeyRoute{key=" + this.key + '}';
    }
}

