/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons;

import java.util.Collection;
import me.extremall.advancedkits.libs.fcommons.MaterialsHelper;
import org.bukkit.Bukkit;
import org.bukkit.Material;

public final class Preconditions {
    public static void notNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static void notNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string + " cannot be null");
        }
    }

    public static void notEmpty(String string, String string2) {
        Preconditions.notNull(string, string2);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(string2 + " cannot be empty");
        }
    }

    public static void notEmpty(Collection<?> collection, String string) {
        Preconditions.notNull(collection, string);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(string + " cannot be empty");
        }
    }

    public static void notEmpty(Object[] objectArray, String string) {
        Preconditions.notNull(objectArray, string);
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(string + " cannot be empty");
        }
    }

    public static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalStateException(string);
        }
    }

    public static void checkIndex(int n2, int n3, String string) {
        Preconditions.checkArgument(n3 >= 0, "size cannot be negative");
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(string + " (" + n2 + ") cannot be negative");
        }
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException(string + " (" + n2 + ") must be less than size (" + n3 + ")");
        }
    }

    public static void checkArgumentNotAir(Material material, String string) {
        Preconditions.notNull(material, string);
        if (MaterialsHelper.isAir(material)) {
            throw new IllegalArgumentException(string + " cannot be " + material);
        }
    }

    public static void checkMainThread(String string) {
        Preconditions.checkState(Bukkit.isPrimaryThread(), string);
    }
}

