/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons.collection;

import java.util.Arrays;
import java.util.function.Function;
import me.extremall.advancedkits.libs.fcommons.Strings;
import me.extremall.advancedkits.libs.fcommons.collection.CaseInsensitiveHashMap;
import me.extremall.advancedkits.libs.fcommons.collection.CaseInsensitiveMap;
import org.jetbrains.annotations.Nullable;

public class LookupRegistry<V> {
    private static final char[] KEY_IGNORE_CHARS = new char[]{'-', '_', ' '};
    private final CaseInsensitiveMap<V> valuesMap = new CaseInsensitiveHashMap();

    public static <V> LookupRegistry<V> fromValues(V[] VArray, Function<V, String> function) {
        return LookupRegistry.fromValues(Arrays.asList(VArray), function);
    }

    public static <V> LookupRegistry<V> fromValues(Iterable<V> iterable, Function<V, String> function) {
        LookupRegistry<V> lookupRegistry = new LookupRegistry<V>();
        lookupRegistry.putAll(iterable, function);
        return lookupRegistry;
    }

    protected LookupRegistry() {
    }

    @Nullable
    public V lookup(String string) {
        if (string == null) {
            return null;
        }
        return this.valuesMap.get(this.removeIgnoredChars(string));
    }

    protected void putAll(Iterable<V> object, Function<V, String> function) {
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.put(function.apply(e2), e2);
        }
    }

    public void put(String string, V v2) {
        this.valuesMap.put(this.removeIgnoredChars(string), v2);
    }

    private String removeIgnoredChars(String string) {
        return Strings.stripChars(string, KEY_IGNORE_CHARS);
    }

    public String toString() {
        return "LookupRegistry [values=" + this.valuesMap + "]";
    }
}

