/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.IMetricsTracker;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.PoolStats;

public final class CodaHaleMetricsTracker
implements IMetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_NAME_WAIT = "Wait";
    private static final String METRIC_NAME_USAGE = "Usage";
    private static final String METRIC_NAME_CONNECT = "ConnectionCreation";
    private static final String METRIC_NAME_TIMEOUT_RATE = "ConnectionTimeoutRate";
    private static final String METRIC_NAME_TOTAL_CONNECTIONS = "TotalConnections";
    private static final String METRIC_NAME_IDLE_CONNECTIONS = "IdleConnections";
    private static final String METRIC_NAME_ACTIVE_CONNECTIONS = "ActiveConnections";
    private static final String METRIC_NAME_PENDING_CONNECTIONS = "PendingConnections";
    private static final String METRIC_NAME_MAX_CONNECTIONS = "MaxConnections";
    private static final String METRIC_NAME_MIN_CONNECTIONS = "MinConnections";

    CodaHaleMetricsTracker(String string, PoolStats poolStats, MetricRegistry metricRegistry) {
        this.poolName = string;
        this.registry = metricRegistry;
        this.connectionObtainTimer = metricRegistry.timer(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_WAIT}));
        this.connectionUsage = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_USAGE}));
        this.connectionCreation = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_CONNECT}));
        this.connectionTimeoutMeter = metricRegistry.meter(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE}));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS}), (Metric)((Gauge)poolStats::getTotalConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS}), (Metric)((Gauge)poolStats::getIdleConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS}), (Metric)((Gauge)poolStats::getActiveConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS}), (Metric)((Gauge)poolStats::getPendingThreads));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS}), (Metric)((Gauge)poolStats::getMaxConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS}), (Metric)((Gauge)poolStats::getMinConnections));
    }

    @Override
    public final void close() {
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_WAIT}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_USAGE}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_CONNECT}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS}));
    }

    @Override
    public final void recordConnectionAcquiredNanos(long l2) {
        this.connectionObtainTimer.update(l2, TimeUnit.NANOSECONDS);
    }

    @Override
    public final void recordConnectionUsageMillis(long l2) {
        this.connectionUsage.update(l2);
    }

    @Override
    public final void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    @Override
    public final void recordConnectionCreatedMillis(long l2) {
        this.connectionCreation.update(l2);
    }

    public final Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public final Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public final Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

