/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.extremall.advancedkits.libs.hikari.hikari.HikariConfig;
import me.extremall.advancedkits.libs.hikari.hikari.HikariPoolMXBean;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.MetricsTrackerFactory;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.PoolStats;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.dropwizard.CodahaleHealthChecker;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolBase;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolEntry;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyConnection;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyLeakTaskFactory;
import me.extremall.advancedkits.libs.hikari.hikari.util.ClockSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.ConcurrentBag;
import me.extremall.advancedkits.libs.hikari.hikari.util.SuspendResumeLock;
import me.extremall.advancedkits.libs.hikari.hikari.util.UtilityElf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger logger = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long aliveBypassWindowMs = Long.getLong("me.extremall.advancedkits.libs.hikari.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long housekeepingPeriodMs = Long.getLong("me.extremall.advancedkits.libs.hikari.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private static final String EVICTED_CONNECTION_MESSAGE = "(connection was evicted)";
    private static final String DEAD_CONNECTION_MESSAGE = "(connection is dead)";
    private final PoolEntryCreator poolEntryCreator = new PoolEntryCreator(null);
    private final PoolEntryCreator postFillPoolEntryCreator = new PoolEntryCreator("After adding ");
    private final Collection<Runnable> addConnectionQueueReadOnlyView;
    private final ThreadPoolExecutor addConnectionExecutor;
    private final ThreadPoolExecutor closeConnectionExecutor;
    private final ConcurrentBag<PoolEntry> connectionBag = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory leakTaskFactory;
    private final SuspendResumeLock suspendResumeLock;
    private final ScheduledExecutorService houseKeepingExecutorService;
    private ScheduledFuture<?> houseKeeperTask;

    public HikariPool(HikariConfig hikariConfig) {
        super(hikariConfig);
        this.suspendResumeLock = hikariConfig.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        this.houseKeepingExecutorService = this.initializeHouseKeepingExecutorService();
        this.checkFailFast();
        if (hikariConfig.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(hikariConfig.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(hikariConfig.getMetricRegistry());
        }
        this.setHealthCheckRegistry(hikariConfig.getHealthCheckRegistry());
        HikariPool hikariPool = this;
        hikariPool.handleMBeans(hikariPool, true);
        ThreadFactory threadFactory = hikariConfig.getThreadFactory();
        int n2 = hikariConfig.getMaximumPoolSize();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n2);
        this.addConnectionQueueReadOnlyView = Collections.unmodifiableCollection(linkedBlockingQueue);
        this.addConnectionExecutor = UtilityElf.createThreadPoolExecutor(linkedBlockingQueue, this.poolName + " connection adder", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        this.closeConnectionExecutor = UtilityElf.createThreadPoolExecutor(n2, this.poolName + " connection closer", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.leakTaskFactory = new ProxyLeakTaskFactory(hikariConfig.getLeakDetectionThreshold(), this.houseKeepingExecutorService);
        this.houseKeeperTask = this.houseKeepingExecutorService.scheduleWithFixedDelay(new HouseKeeper(), 100L, this.housekeepingPeriodMs, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("me.extremall.advancedkits.libs.hikari.hikari.blockUntilFilled") && hikariConfig.getInitializationFailTimeout() > 1L) {
            this.addConnectionExecutor.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.addConnectionExecutor.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long l2 = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(l2) < hikariConfig.getInitializationFailTimeout() && this.getTotalConnections() < hikariConfig.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.addConnectionExecutor.setCorePoolSize(1);
            this.addConnectionExecutor.setMaximumPoolSize(1);
        }
    }

    public final Connection getConnection() {
        HikariPool hikariPool = this;
        return hikariPool.getConnection(hikariPool.connectionTimeout);
    }

    /*
     * Exception decompiling
     */
    public final Connection getConnection(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final synchronized void shutdown() {
        block8: {
            this.poolState = 2;
            if (this.addConnectionExecutor != null) break block8;
            this.logPoolState("After shutdown ");
            HikariPool hikariPool = this;
            hikariPool.handleMBeans(hikariPool, false);
            this.metricsTracker.close();
            return;
        }
        try {
            this.logPoolState("Before shutdown ");
            if (this.houseKeeperTask != null) {
                this.houseKeeperTask.cancel(false);
                this.houseKeeperTask = null;
            }
            this.softEvictConnections();
            this.addConnectionExecutor.shutdown();
            this.addConnectionExecutor.awaitTermination(this.getLoginTimeout(), TimeUnit.SECONDS);
            this.destroyHouseKeepingExecutorService();
            this.connectionBag.close();
            ThreadPoolExecutor threadPoolExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), this.poolName + " connection assassinator", this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long l2 = ClockSource.currentTime();
                do {
                    this.abortActiveConnections(threadPoolExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(l2) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                threadPoolExecutor.shutdown();
                threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.shutdownNetworkTimeoutExecutor();
            this.closeConnectionExecutor.shutdown();
            this.closeConnectionExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            this.logPoolState("After shutdown ");
            HikariPool hikariPool = this;
            hikariPool.handleMBeans(hikariPool, false);
            this.metricsTracker.close();
            throw throwable;
        }
        this.logPoolState("After shutdown ");
        HikariPool hikariPool = this;
        hikariPool.handleMBeans(hikariPool, false);
        this.metricsTracker.close();
    }

    public final void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.cancelLeakTask();
        try {
            this.softEvictConnection(proxyConnection.getPoolEntry(), "(connection evicted by user)", !connection.isClosed());
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public final void setMetricRegistry(Object object) {
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)object));
            return;
        }
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)object));
            return;
        }
        this.setMetricsTrackerFactory(null);
    }

    public final void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (metricsTrackerFactory != null) {
            this.metricsTracker = new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), this.getPoolStats()));
            return;
        }
        this.metricsTracker = new PoolBase.NopMetricsTrackerDelegate();
    }

    public final void setHealthCheckRegistry(Object object) {
        if (object != null) {
            HikariPool hikariPool = this;
            CodahaleHealthChecker.registerHealthChecks(hikariPool, hikariPool.config, (HealthCheckRegistry)object);
        }
    }

    @Override
    public final void addBagItem(int n2) {
        boolean bl2 = n2 - this.addConnectionQueueReadOnlyView.size() >= 0;
        if (bl2) {
            this.addConnectionExecutor.submit(this.poolEntryCreator);
            return;
        }
        this.logger.debug("{} - Add connection elided, waiting {}, queue {}", new Object[]{this.poolName, n2, this.addConnectionQueueReadOnlyView.size()});
    }

    @Override
    public final int getActiveConnections() {
        return this.connectionBag.getCount(1);
    }

    @Override
    public final int getIdleConnections() {
        return this.connectionBag.getCount(0);
    }

    @Override
    public final int getTotalConnections() {
        return this.connectionBag.size();
    }

    @Override
    public final int getThreadsAwaitingConnection() {
        return this.connectionBag.getWaitingThreadCount();
    }

    @Override
    public final void softEvictConnections() {
        this.connectionBag.values().forEach(poolEntry -> this.softEvictConnection((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public final synchronized void suspendPool() {
        if (this.suspendResumeLock == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(this.poolName + " - is not suspendable");
        }
        if (this.poolState != 1) {
            this.suspendResumeLock.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public final synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.fillPool();
            this.suspendResumeLock.resume();
        }
    }

    final void logPoolState(String ... stringArray) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} - {}stats (total={}, active={}, idle={}, waiting={})", new Object[]{this.poolName, stringArray.length > 0 ? stringArray[0] : "", this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection()});
        }
    }

    @Override
    final void recycle(PoolEntry poolEntry) {
        this.metricsTracker.recordConnectionUsage(poolEntry);
        this.connectionBag.requite(poolEntry);
    }

    final void closeConnection(PoolEntry object, String string) {
        if (this.connectionBag.remove((PoolEntry)object)) {
            object = ((PoolEntry)object).close();
            this.closeConnectionExecutor.execute(() -> this.lambda$closeConnection$1((Connection)object, string));
        }
    }

    final int[] getPoolStateCounts() {
        return this.connectionBag.getStateCounts();
    }

    private PoolEntry createPoolEntry() {
        block6: {
            try {
                long l2;
                long l3;
                PoolEntry poolEntry = this.newPoolEntry();
                long l4 = this.config.getMaxLifetime();
                if (l4 > 0L) {
                    l3 = l4 > 10000L ? ThreadLocalRandom.current().nextLong(l4 / 40L) : 0L;
                    l2 = l4 - l3;
                    poolEntry.setFutureEol(this.houseKeepingExecutorService.schedule(new MaxLifetimeTask(poolEntry), l2, TimeUnit.MILLISECONDS));
                }
                if ((l3 = this.config.getKeepaliveTime()) > 0L) {
                    long l5;
                    l2 = ThreadLocalRandom.current().nextLong(l3 / 10L);
                    long l6 = l5 = l3 - l2;
                    poolEntry.setKeepalive(this.houseKeepingExecutorService.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), l6, l6, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException connectionSetupException) {
                if (this.poolState == 0) {
                    this.logger.error("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)connectionSetupException.getCause());
                    this.lastConnectionFailure.set(connectionSetupException);
                }
            }
            catch (Exception exception) {
                if (this.poolState != 0) break block6;
                this.logger.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)exception);
            }
        }
        return null;
    }

    private synchronized void fillPool() {
        int n2 = Math.min(this.config.getMaximumPoolSize() - this.getTotalConnections(), this.config.getMinimumIdle() - this.getIdleConnections()) - this.addConnectionQueueReadOnlyView.size();
        if (n2 <= 0) {
            this.logger.debug("{} - Fill pool skipped, pool is at sufficient level.", (Object)this.poolName);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addConnectionExecutor.submit(i2 < n2 - 1 ? this.poolEntryCreator : this.postFillPoolEntryCreator);
        }
    }

    private void abortActiveConnections(ExecutorService executorService) {
        for (PoolEntry poolEntry : this.connectionBag.values(1)) {
            Connection connection = poolEntry.close();
            try {
                connection.abort(executorService);
            }
            catch (Throwable throwable) {
                this.quietlyCloseConnection(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.connectionBag.remove(poolEntry);
            }
        }
    }

    private void checkFailFast() {
        long l2 = this.config.getInitializationFailTimeout();
        if (l2 < 0L) {
            return;
        }
        long l3 = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.createPoolEntry()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.connectionBag.add(poolEntry);
                    this.logger.debug("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.connection);
                    return;
                }
                this.quietlyCloseConnection(poolEntry.close(), "(initialization check complete and minimumIdle is zero)");
                return;
            }
            if (this.getLastConnectionFailure() instanceof PoolBase.ConnectionSetupException) {
                HikariPool hikariPool = this;
                hikariPool.throwPoolInitializationException(hikariPool.getLastConnectionFailure().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(l3) < l2);
        if (l2 > 0L) {
            HikariPool hikariPool = this;
            hikariPool.throwPoolInitializationException(hikariPool.getLastConnectionFailure());
        }
    }

    private void throwPoolInitializationException(Throwable throwable) {
        this.logger.error("{} - Exception during pool initialization.", (Object)this.poolName, (Object)throwable);
        this.destroyHouseKeepingExecutorService();
        throw new PoolInitializationException(throwable);
    }

    private boolean softEvictConnection(PoolEntry poolEntry, String string, boolean bl2) {
        poolEntry.markEvicted();
        if (bl2 || this.connectionBag.reserve(poolEntry)) {
            this.closeConnection(poolEntry, string);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService initializeHouseKeepingExecutorService() {
        if (this.config.getScheduledExecutor() == null) {
            Object object = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            object = new ScheduledThreadPoolExecutor(1, (ThreadFactory)object, new ThreadPoolExecutor.DiscardPolicy());
            ((ScheduledThreadPoolExecutor)object).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            ((ScheduledThreadPoolExecutor)object).setRemoveOnCancelPolicy(true);
            return object;
        }
        return this.config.getScheduledExecutor();
    }

    private void destroyHouseKeepingExecutorService() {
        if (this.config.getScheduledExecutor() == null) {
            this.houseKeepingExecutorService.shutdownNow();
        }
    }

    private PoolStats getPoolStats() {
        return new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

            @Override
            public void update() {
                this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                this.idleConnections = HikariPool.this.getIdleConnections();
                this.totalConnections = HikariPool.this.getTotalConnections();
                this.activeConnections = HikariPool.this.getActiveConnections();
                this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                this.minConnections = HikariPool.this.config.getMinimumIdle();
            }
        };
    }

    private SQLException createTimeoutException(long l2) {
        this.logPoolState("Timeout failure ");
        this.metricsTracker.recordConnectionTimeout();
        String string = null;
        Exception exception = this.getLastConnectionFailure();
        if (exception instanceof SQLException) {
            string = ((SQLException)exception).getSQLState();
        }
        SQLTransientConnectionException sQLTransientConnectionException = new SQLTransientConnectionException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(l2) + "ms.", string, exception);
        if (exception instanceof SQLException) {
            sQLTransientConnectionException.setNextException((SQLException)exception);
        }
        return sQLTransientConnectionException;
    }

    private /* synthetic */ void lambda$closeConnection$1(Connection connection, String string) {
        this.quietlyCloseConnection(connection, string);
        if (this.poolState == 0) {
            this.fillPool();
        }
    }

    public static class PoolInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 929872118275916520L;

        public PoolInitializationException(Throwable throwable) {
            super("Failed to initialize pool: " + throwable.getMessage(), throwable);
        }
    }

    final class KeepaliveTask
    implements Runnable {
        private final PoolEntry poolEntry;

        KeepaliveTask(PoolEntry poolEntry) {
            this.poolEntry = poolEntry;
        }

        @Override
        public final void run() {
            if (HikariPool.this.connectionBag.reserve(this.poolEntry)) {
                if (!HikariPool.this.isConnectionAlive(this.poolEntry.connection)) {
                    HikariPool.this.softEvictConnection(this.poolEntry, HikariPool.DEAD_CONNECTION_MESSAGE, true);
                    HikariPool.this.addBagItem(HikariPool.this.connectionBag.getWaitingThreadCount());
                    return;
                }
                HikariPool.this.connectionBag.unreserve(this.poolEntry);
                HikariPool.this.logger.debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.poolEntry.connection);
            }
        }
    }

    final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry poolEntry;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.poolEntry = poolEntry;
        }

        @Override
        public final void run() {
            if (HikariPool.this.softEvictConnection(this.poolEntry, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.connectionBag.getWaitingThreadCount());
            }
        }
    }

    final class HouseKeeper
    implements Runnable {
        private volatile long previous;

        private HouseKeeper() {
            this.previous = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.housekeepingPeriodMs);
        }

        @Override
        public final void run() {
            try {
                HikariPool.this.connectionTimeout = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.validationTimeout = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.leakTaskFactory.updateLeakDetectionThreshold(HikariPool.this.config.getLeakDetectionThreshold());
                HikariPool.this.catalog = HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.catalog) ? HikariPool.this.config.getCatalog() : HikariPool.this.catalog;
                long l2 = HikariPool.this.config.getIdleTimeout();
                long l3 = ClockSource.currentTime();
                if (ClockSource.plusMillis(l3, 128L) < ClockSource.plusMillis(this.previous, HikariPool.this.housekeepingPeriodMs)) {
                    HikariPool.this.logger.warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, l3));
                    this.previous = l3;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (l3 > ClockSource.plusMillis(this.previous, 3L * HikariPool.this.housekeepingPeriodMs / 2L)) {
                    HikariPool.this.logger.warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, l3));
                }
                this.previous = l3;
                String string = "Pool ";
                if (l2 > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.logPoolState("Before cleanup ");
                    string = "After cleanup  ";
                    Object object = HikariPool.this.connectionBag.values(0);
                    int n2 = object.size() - HikariPool.this.config.getMinimumIdle();
                    object = object.iterator();
                    while (object.hasNext()) {
                        PoolEntry poolEntry = (PoolEntry)object.next();
                        if (n2 <= 0 || ClockSource.elapsedMillis(poolEntry.lastAccessed, l3) <= l2 || !HikariPool.this.connectionBag.reserve(poolEntry)) continue;
                        HikariPool.this.closeConnection(poolEntry, "(connection has passed idleTimeout)");
                        --n2;
                    }
                }
                HikariPool.this.logPoolState(string);
                HikariPool.this.fillPool();
                return;
            }
            catch (Exception exception) {
                HikariPool.this.logger.error("Unexpected exception in housekeeping task", (Throwable)exception);
                return;
            }
        }
    }

    final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String loggingPrefix;

        PoolEntryCreator(String string) {
            this.loggingPrefix = string;
        }

        @Override
        public final Boolean call() {
            long l2 = 250L;
            while (HikariPool.this.poolState == 0 && this.shouldCreateAnotherConnection()) {
                PoolEntry poolEntry = HikariPool.this.createPoolEntry();
                if (poolEntry != null) {
                    HikariPool.this.connectionBag.add(poolEntry);
                    HikariPool.this.logger.debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.connection);
                    if (this.loggingPrefix != null) {
                        HikariPool.this.logPoolState(this.loggingPrefix);
                    }
                    return Boolean.TRUE;
                }
                if (this.loggingPrefix != null) {
                    HikariPool.this.logger.debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)l2);
                }
                UtilityElf.quietlySleep(l2);
                l2 = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(HikariPool.this.connectionTimeout, (long)((double)l2 * 1.5)));
            }
            return Boolean.FALSE;
        }

        private synchronized boolean shouldCreateAnotherConnection() {
            return HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.connectionBag.getWaitingThreadCount() > 0 || HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle());
        }
    }
}

