/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyConnection;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyFactory;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyResultSet;

public abstract class ProxyStatement
implements Statement {
    protected final ProxyConnection connection;
    final Statement delegate;
    private boolean isClosed;
    private ResultSet proxyResultSet;

    ProxyStatement(ProxyConnection proxyConnection, Statement statement) {
        this.connection = proxyConnection;
        this.delegate = statement;
    }

    final SQLException checkException(SQLException sQLException) {
        return this.connection.checkException(sQLException);
    }

    public final String toString() {
        String string = this.delegate.toString();
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + string;
    }

    @Override
    public final void close() {
        ProxyStatement proxyStatement = this;
        synchronized (proxyStatement) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.connection.untrackStatement(this.delegate);
        try {
            this.delegate.close();
            return;
        }
        catch (SQLException sQLException) {
            throw this.connection.checkException(sQLException);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean execute(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string);
    }

    @Override
    public boolean execute(String string, int n2) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, n2);
    }

    @Override
    public ResultSet executeQuery(String object) {
        this.connection.markCommitStateDirty();
        object = this.delegate.executeQuery((String)object);
        return ProxyFactory.getProxyResultSet(this.connection, this, (ResultSet)object);
    }

    @Override
    public int executeUpdate(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string);
    }

    @Override
    public int[] executeBatch() {
        this.connection.markCommitStateDirty();
        return this.delegate.executeBatch();
    }

    @Override
    public int executeUpdate(String string, int n2) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, n2);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, nArray);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, stringArray);
    }

    @Override
    public boolean execute(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, nArray);
    }

    @Override
    public boolean execute(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, stringArray);
    }

    @Override
    public long[] executeLargeBatch() {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string);
    }

    @Override
    public long executeLargeUpdate(String string, int n2) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, n2);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, nArray);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, stringArray);
    }

    @Override
    public ResultSet getResultSet() {
        ResultSet resultSet = this.delegate.getResultSet();
        if (resultSet != null) {
            if (this.proxyResultSet == null || ((ProxyResultSet)this.proxyResultSet).delegate != resultSet) {
                this.proxyResultSet = ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
            }
        } else {
            this.proxyResultSet = null;
        }
        return this.proxyResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        ResultSet resultSet = this.delegate.getGeneratedKeys();
        if (this.proxyResultSet == null || ((ProxyResultSet)this.proxyResultSet).delegate != resultSet) {
            this.proxyResultSet = ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
        }
        return this.proxyResultSet;
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped statement is not an instance of " + clazz);
    }
}

