/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class FastList<T>
implements Serializable,
List<T>,
RandomAccess {
    private static final long serialVersionUID = -4598088075242913858L;
    private final Class<?> clazz;
    private T[] elementData;
    private int size;

    public FastList(Class<?> clazz) {
        this.elementData = (Object[])Array.newInstance(clazz, 32);
        this.clazz = clazz;
    }

    public FastList(Class<?> clazz, int n2) {
        this.elementData = (Object[])Array.newInstance(clazz, n2);
        this.clazz = clazz;
    }

    @Override
    public final boolean add(T t2) {
        if (this.size < this.elementData.length) {
            this.elementData[this.size++] = t2;
        } else {
            int n2 = this.elementData.length;
            int n3 = n2 << 1;
            Object[] objectArray = (Object[])Array.newInstance(this.clazz, n3);
            System.arraycopy(this.elementData, 0, objectArray, 0, n2);
            objectArray[this.size++] = t2;
            this.elementData = objectArray;
        }
        return true;
    }

    @Override
    public final T get(int n2) {
        return this.elementData[n2];
    }

    @Override
    public final T removeLast() {
        T t2 = this.elementData[--this.size];
        this.elementData[this.size] = null;
        return t2;
    }

    @Override
    public final boolean remove(Object object) {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (object != this.elementData[i2]) continue;
            int n2 = this.size - i2 - 1;
            if (n2 > 0) {
                System.arraycopy(this.elementData, i2 + 1, this.elementData, i2, n2);
            }
            this.elementData[--this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public final void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elementData[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final T set(int n2, T t2) {
        T t3 = this.elementData[n2];
        this.elementData[n2] = t2;
        return t3;
    }

    @Override
    public final T remove(int n2) {
        if (this.size == 0) {
            return null;
        }
        T t2 = this.elementData[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
        return t2;
    }

    @Override
    public final boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < FastList.this.size;
            }

            @Override
            public T next() {
                if (this.index < FastList.this.size) {
                    return FastList.this.elementData[this.index++];
                }
                throw new NoSuchElementException("No more elements in FastList");
            }
        };
    }

    @Override
    public final Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <E> E[] toArray(E[] EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int n2, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int n2, T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int indexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int lastIndexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ListIterator<T> listIterator(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final List<T> subList(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public final Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void forEach(Consumer<? super T> consumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Spliterator<T> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void replaceAll(UnaryOperator<T> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void sort(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException();
    }
}

