/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagIO;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagType;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagTypes;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CompoundBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IOStreamUtil;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.TrackingDataInput;
import org.jetbrains.annotations.NotNull;

final class BinaryTagReaderImpl
implements BinaryTagIO.Reader {
    private final long maxBytes;
    static final BinaryTagIO.Reader UNLIMITED = new BinaryTagReaderImpl(-1L);
    static final BinaryTagIO.Reader DEFAULT_LIMIT = new BinaryTagReaderImpl(131082L);

    BinaryTagReaderImpl(long l2) {
        this.maxBytes = l2;
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull Path object, @NotNull BinaryTagIO.Compression object2) {
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        try {
            object2 = this.read((InputStream)object, (BinaryTagIO.Compression)object2);
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull InputStream inputStream, @NotNull BinaryTagIO.Compression object) {
        inputStream = new DataInputStream(new BufferedInputStream(((BinaryTagIO.Compression)object).decompress(IOStreamUtil.closeShield(inputStream))));
        try {
            object = this.read((DataInput)((Object)inputStream));
            return object;
        }
        finally {
            ((FilterInputStream)inputStream).close();
        }
    }

    @Override
    @NotNull
    public final CompoundBinaryTag read(@NotNull DataInput dataInput) {
        if (!(dataInput instanceof TrackingDataInput)) {
            dataInput = new TrackingDataInput(dataInput, this.maxBytes);
        }
        BinaryTagType<BinaryTag> binaryTagType = BinaryTagType.of(dataInput.readByte());
        BinaryTagReaderImpl.requireCompound(binaryTagType);
        DataInput dataInput2 = dataInput;
        dataInput2.skipBytes(dataInput2.readUnsignedShort());
        return BinaryTagTypes.COMPOUND.read(dataInput);
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull Path object, @NotNull BinaryTagIO.Compression object2) {
        object = Files.newInputStream((Path)object, new OpenOption[0]);
        try {
            object2 = this.readNamed((InputStream)object, (BinaryTagIO.Compression)object2);
            return object2;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull InputStream inputStream, @NotNull BinaryTagIO.Compression object) {
        inputStream = new DataInputStream(new BufferedInputStream(((BinaryTagIO.Compression)object).decompress(IOStreamUtil.closeShield(inputStream))));
        try {
            object = this.readNamed((DataInput)((Object)inputStream));
            return object;
        }
        finally {
            ((FilterInputStream)inputStream).close();
        }
    }

    @Override
    public final  @NotNull Map.Entry<String, CompoundBinaryTag> readNamed(@NotNull DataInput dataInput) {
        Object object = BinaryTagType.of(dataInput.readByte());
        BinaryTagReaderImpl.requireCompound(object);
        object = dataInput.readUTF();
        return new AbstractMap.SimpleImmutableEntry<Object, CompoundBinaryTag>(object, BinaryTagTypes.COMPOUND.read(dataInput));
    }

    private static void requireCompound(BinaryTagType<? extends BinaryTag> binaryTagType) {
        if (binaryTagType != BinaryTagTypes.COMPOUND) {
            throw new IOException(String.format("Expected root tag to be a %s, was %s", BinaryTagTypes.COMPOUND, binaryTagType));
        }
    }
}

