/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagScope;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTagType;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CompoundBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CompoundBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.DoubleBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.EndBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.FloatBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ListBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ShortBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.StringBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.TrackingDataInput;

public final class BinaryTagTypes {
    public static final BinaryTagType<EndBinaryTag> END = BinaryTagType.register(EndBinaryTag.class, (byte)0, dataInput -> EndBinaryTag.get(), null);
    public static final BinaryTagType<ByteBinaryTag> BYTE = BinaryTagType.registerNumeric(ByteBinaryTag.class, (byte)1, dataInput -> ByteBinaryTag.of(dataInput.readByte()), (byteBinaryTag, dataOutput) -> dataOutput.writeByte(byteBinaryTag.value()));
    public static final BinaryTagType<ShortBinaryTag> SHORT = BinaryTagType.registerNumeric(ShortBinaryTag.class, (byte)2, dataInput -> ShortBinaryTag.of(dataInput.readShort()), (shortBinaryTag, dataOutput) -> dataOutput.writeShort(shortBinaryTag.value()));
    public static final BinaryTagType<IntBinaryTag> INT = BinaryTagType.registerNumeric(IntBinaryTag.class, (byte)3, dataInput -> IntBinaryTag.of(dataInput.readInt()), (intBinaryTag, dataOutput) -> dataOutput.writeInt(intBinaryTag.value()));
    public static final BinaryTagType<LongBinaryTag> LONG = BinaryTagType.registerNumeric(LongBinaryTag.class, (byte)4, dataInput -> LongBinaryTag.of(dataInput.readLong()), (longBinaryTag, dataOutput) -> dataOutput.writeLong(longBinaryTag.value()));
    public static final BinaryTagType<FloatBinaryTag> FLOAT = BinaryTagType.registerNumeric(FloatBinaryTag.class, (byte)5, dataInput -> FloatBinaryTag.of(dataInput.readFloat()), (floatBinaryTag, dataOutput) -> dataOutput.writeFloat(floatBinaryTag.value()));
    public static final BinaryTagType<DoubleBinaryTag> DOUBLE = BinaryTagType.registerNumeric(DoubleBinaryTag.class, (byte)6, dataInput -> DoubleBinaryTag.of(dataInput.readDouble()), (doubleBinaryTag, dataOutput) -> dataOutput.writeDouble(doubleBinaryTag.value()));
    public static final BinaryTagType<ByteArrayBinaryTag> BYTE_ARRAY = BinaryTagType.register(ByteArrayBinaryTag.class, (byte)7, object -> {
        int n2 = object.readInt();
        try (BinaryTagScope binaryTagScope = TrackingDataInput.enter(object, n2);){
            byte[] byArray = new byte[n2];
            object.readFully(byArray);
            object = ByteArrayBinaryTag.of(byArray);
            return object;
        }
    }, (object, dataOutput) -> {
        object = ByteArrayBinaryTagImpl.value((ByteArrayBinaryTag)object);
        dataOutput.writeInt(((Object)object).length);
        dataOutput.write((byte[])object);
    });
    public static final BinaryTagType<StringBinaryTag> STRING = BinaryTagType.register(StringBinaryTag.class, (byte)8, dataInput -> StringBinaryTag.of(dataInput.readUTF()), (stringBinaryTag, dataOutput) -> dataOutput.writeUTF(stringBinaryTag.value()));
    public static final BinaryTagType<ListBinaryTag> LIST = BinaryTagType.register(ListBinaryTag.class, (byte)9, dataInput -> {
        BinaryTagType<BinaryTag> binaryTagType = BinaryTagType.of(dataInput.readByte());
        int n2 = dataInput.readInt();
        try (BinaryTagScope binaryTagScope = TrackingDataInput.enter(dataInput, (long)n2 << 3);){
            ArrayList<BinaryTag> arrayList = new ArrayList<BinaryTag>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(binaryTagType.read(dataInput));
            }
            ListBinaryTag listBinaryTag = ListBinaryTag.of(binaryTagType, arrayList);
            return listBinaryTag;
        }
    }, (object, dataOutput) -> {
        dataOutput.writeByte(object.elementType().id());
        int n2 = object.size();
        dataOutput.writeInt(n2);
        object = object.iterator();
        while (object.hasNext()) {
            BinaryTag binaryTag = (BinaryTag)object.next();
            BinaryTagType.writeUntyped(binaryTag.type(), binaryTag, dataOutput);
        }
    });
    public static final BinaryTagType<CompoundBinaryTag> COMPOUND = BinaryTagType.register(CompoundBinaryTag.class, (byte)10, dataInput -> {
        try (BinaryTagScope binaryTagScope = TrackingDataInput.enter(dataInput);){
            Object object;
            Object object2;
            HashMap<String, BinaryTag> hashMap = new HashMap<String, BinaryTag>();
            while ((object2 = BinaryTagType.of(dataInput.readByte())) != END) {
                object = dataInput.readUTF();
                object2 = ((BinaryTagType)object2).read(dataInput);
                hashMap.put((String)object, (BinaryTag)object2);
            }
            object = new CompoundBinaryTagImpl(hashMap);
            return object;
        }
    }, (object, dataOutput) -> {
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            BinaryTag binaryTag = (BinaryTag)entry.getValue();
            if (binaryTag == null) continue;
            BinaryTagType<? extends BinaryTag> binaryTagType = binaryTag.type();
            dataOutput.writeByte(binaryTagType.id());
            if (binaryTagType == END) continue;
            dataOutput.writeUTF((String)entry.getKey());
            BinaryTagType.writeUntyped(binaryTagType, binaryTag, dataOutput);
        }
        dataOutput.writeByte(END.id());
    });
    public static final BinaryTagType<IntArrayBinaryTag> INT_ARRAY = BinaryTagType.register(IntArrayBinaryTag.class, (byte)11, dataInput -> {
        int n2 = dataInput.readInt();
        try (BinaryTagScope binaryTagScope = TrackingDataInput.enter(dataInput, (long)n2 << 2);){
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = dataInput.readInt();
            }
            IntArrayBinaryTag intArrayBinaryTag = IntArrayBinaryTag.of(nArray);
            return intArrayBinaryTag;
        }
    }, (object, dataOutput) -> {
        int[] nArray = IntArrayBinaryTagImpl.value((IntArrayBinaryTag)object);
        object = nArray;
        int n2 = nArray.length;
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeInt((int)object[i2]);
        }
    });
    public static final BinaryTagType<LongArrayBinaryTag> LONG_ARRAY = BinaryTagType.register(LongArrayBinaryTag.class, (byte)12, dataInput -> {
        int n2 = dataInput.readInt();
        try (BinaryTagScope binaryTagScope = TrackingDataInput.enter(dataInput, (long)n2 << 3);){
            long[] lArray = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                lArray[i2] = dataInput.readLong();
            }
            LongArrayBinaryTag longArrayBinaryTag = LongArrayBinaryTag.of(lArray);
            return longArrayBinaryTag;
        }
    }, (object, dataOutput) -> {
        long[] lArray = LongArrayBinaryTagImpl.value((LongArrayBinaryTag)object);
        object = lArray;
        int n2 = lArray.length;
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeLong((long)object[i2]);
        }
    });

    private BinaryTagTypes() {
    }
}

