/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ArrayBinaryTagImpl;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"long[\" + this.value.length + \"]\"", childrenArray="this.value", hasChildren="this.value.length > 0")
final class LongArrayBinaryTagImpl
extends ArrayBinaryTagImpl
implements LongArrayBinaryTag {
    final long[] value;

    LongArrayBinaryTagImpl(long[] lArray) {
        this.value = Arrays.copyOf(lArray, lArray.length);
    }

    @Override
    public final long @NotNull [] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public final int size() {
        return this.value.length;
    }

    @Override
    public final long get(int n2) {
        LongArrayBinaryTagImpl.checkIndex(n2, this.value.length);
        return this.value[n2];
    }

    @Override
    public final  @NotNull PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < LongArrayBinaryTagImpl.this.value.length - 1;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongArrayBinaryTagImpl.this.value[this.index++];
            }
        };
    }

    @Override
    public final  @NotNull Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.value);
    }

    @Override
    @NotNull
    public final LongStream stream() {
        return Arrays.stream(this.value);
    }

    @Override
    public final void forEachLong(@NotNull LongConsumer longConsumer) {
        int n2 = this.value.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            longConsumer.accept(this.value[i2]);
        }
    }

    static long[] value(LongArrayBinaryTag longArrayBinaryTag) {
        if (longArrayBinaryTag instanceof LongArrayBinaryTagImpl) {
            return ((LongArrayBinaryTagImpl)longArrayBinaryTag).value;
        }
        return longArrayBinaryTag.value();
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (LongArrayBinaryTagImpl)object;
        return Arrays.equals(this.value, ((LongArrayBinaryTagImpl)object).value);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }
}

