/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.BinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ByteBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CharBuffer;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.CompoundBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.DoubleBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.FloatBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.IntBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ListBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.LongBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.ShortBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.StringBinaryTag;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.Tokens;

final class TagStringReader {
    private static final int MAX_DEPTH = 512;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final CharBuffer buffer;
    private boolean acceptLegacy;
    private int depth;

    TagStringReader(CharBuffer charBuffer) {
        this.buffer = charBuffer;
    }

    public final CompoundBinaryTag compound() {
        this.buffer.expect('{');
        if (this.buffer.takeIf('}')) {
            return CompoundBinaryTag.empty();
        }
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        while (this.buffer.hasMore()) {
            builder.put(this.key(), this.tag());
            if (!this.separatorOrCompleteWith('}')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Unterminated compound tag!");
    }

    public final ListBinaryTag list() {
        ListBinaryTag.Builder<BinaryTag> builder = ListBinaryTag.builder();
        this.buffer.expect('[');
        boolean bl2 = this.acceptLegacy && this.buffer.peek() == '0' && this.buffer.peek(1) == ':';
        if (!bl2 && this.buffer.takeIf(']')) {
            return ListBinaryTag.empty();
        }
        while (this.buffer.hasMore()) {
            if (bl2) {
                this.buffer.takeUntil(':');
            }
            BinaryTag binaryTag = this.tag();
            builder.add(binaryTag);
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Reached end of file without end of list tag!");
    }

    public final BinaryTag array(char c2) {
        this.buffer.expect('[').expect(c2).expect(';');
        c2 = Character.toLowerCase(c2);
        if (c2 == 'b') {
            return ByteArrayBinaryTag.of(this.byteArray());
        }
        if (c2 == 'i') {
            return IntArrayBinaryTag.of(this.intArray());
        }
        if (c2 == 'l') {
            return LongArrayBinaryTag.of(this.longArray());
        }
        throw this.buffer.makeError("Type " + c2 + " is not a valid element type in an array!");
    }

    private byte[] byteArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_BYTE_ARRAY;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        while (this.buffer.hasMore()) {
            Object object = this.buffer.skipWhitespace().takeUntil('b');
            try {
                arrayList.add(Byte.valueOf(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a byte array must be bytes!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            object = new byte[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                object[i2] = (Byte)arrayList.get(i2);
            }
            return object;
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private int[] intArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_INT_ARRAY;
        }
        IntStream.Builder builder = IntStream.builder();
        while (this.buffer.hasMore()) {
            BinaryTag binaryTag = this.tag();
            if (!(binaryTag instanceof IntBinaryTag)) {
                throw this.buffer.makeError("All elements of an int array must be ints!");
            }
            builder.add(((IntBinaryTag)binaryTag).intValue());
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private long[] longArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_LONG_ARRAY;
        }
        LongStream.Builder builder = LongStream.builder();
        while (this.buffer.hasMore()) {
            CharSequence charSequence = this.buffer.skipWhitespace().takeUntil('l');
            try {
                builder.add(Long.parseLong(charSequence.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a long array must be longs!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    public final String key() {
        this.buffer.skipWhitespace();
        char c2 = this.buffer.peek();
        try {
            if (c2 == '\'' || c2 == '\"') {
                String string = TagStringReader.unescape(this.buffer.takeUntil(this.buffer.take()).toString());
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (this.buffer.hasMore()) {
                char c3 = this.buffer.peek();
                if (!Tokens.id(c3)) {
                    if (!this.acceptLegacy) break;
                    if (c3 == '\\') {
                        this.buffer.take();
                        continue;
                    }
                    if (c3 == ':') break;
                    stringBuilder.append(this.buffer.take());
                    continue;
                }
                stringBuilder.append(this.buffer.take());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.buffer.expect(':');
        }
    }

    public final BinaryTag tag() {
        if (this.depth++ > 512) {
            throw this.buffer.makeError("Exceeded maximum allowed depth of 512 when reading tag");
        }
        try {
            char c2 = this.buffer.skipWhitespace().peek();
            switch (c2) {
                case '{': {
                    CompoundBinaryTag compoundBinaryTag = this.compound();
                    return compoundBinaryTag;
                }
                case '[': {
                    if (this.buffer.hasMore(2) && this.buffer.peek(2) == ';') {
                        TagStringReader tagStringReader = this;
                        BinaryTag binaryTag = tagStringReader.array(tagStringReader.buffer.peek(1));
                        return binaryTag;
                    }
                    ListBinaryTag listBinaryTag = this.list();
                    return listBinaryTag;
                }
                case '\"': 
                case '\'': {
                    this.buffer.advance();
                    StringBinaryTag stringBinaryTag = StringBinaryTag.of(TagStringReader.unescape(this.buffer.takeUntil(c2).toString()));
                    return stringBinaryTag;
                }
            }
            BinaryTag binaryTag = this.scalar();
            return binaryTag;
        }
        finally {
            --this.depth;
        }
    }

    private BinaryTag scalar() {
        CharSequence charSequence;
        block22: {
            int n2;
            charSequence = new StringBuilder();
            int n3 = -1;
            while (this.buffer.hasMore()) {
                char c2 = this.buffer.peek();
                n2 = c2;
                if (c2 == '\\') {
                    this.buffer.advance();
                    n2 = this.buffer.take();
                } else {
                    if (!Tokens.id((char)n2)) break;
                    this.buffer.advance();
                }
                ((StringBuilder)charSequence).append((char)n2);
                if (n3 != -1 || Tokens.numeric((char)n2)) continue;
                n3 = ((StringBuilder)charSequence).length();
            }
            n2 = ((StringBuilder)charSequence).length();
            charSequence = ((StringBuilder)charSequence).toString();
            if (n3 == n2 && n2 > 1) {
                n3 = ((String)charSequence).charAt(n2 - '\u0001');
                try {
                    switch (Character.toLowerCase((char)n3)) {
                        case 'b': {
                            return ByteBinaryTag.of(Byte.parseByte(((String)charSequence).substring(0, n2 - 1)));
                        }
                        case 's': {
                            return ShortBinaryTag.of(Short.parseShort(((String)charSequence).substring(0, n2 - 1)));
                        }
                        case 'i': {
                            return IntBinaryTag.of(Integer.parseInt(((String)charSequence).substring(0, n2 - 1)));
                        }
                        case 'l': {
                            return LongBinaryTag.of(Long.parseLong(((String)charSequence).substring(0, n2 - 1)));
                        }
                        case 'f': {
                            float f2 = Float.parseFloat(((String)charSequence).substring(0, n2 - 1));
                            if (!Float.isFinite(f2)) break;
                            return FloatBinaryTag.of(f2);
                        }
                        case 'd': {
                            double d2 = Double.parseDouble(((String)charSequence).substring(0, n2 - 1));
                            if (!Double.isFinite(d2)) break;
                            return DoubleBinaryTag.of(d2);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n3 == -1) {
                try {
                    return IntBinaryTag.of(Integer.parseInt((String)charSequence));
                }
                catch (NumberFormatException numberFormatException) {
                    if (((String)charSequence).indexOf(46) == -1) break block22;
                    try {
                        return DoubleBinaryTag.of(Double.parseDouble((String)charSequence));
                    }
                    catch (NumberFormatException numberFormatException2) {}
                }
            }
        }
        if (((String)charSequence).equalsIgnoreCase("true")) {
            return ByteBinaryTag.ONE;
        }
        if (((String)charSequence).equalsIgnoreCase("false")) {
            return ByteBinaryTag.ZERO;
        }
        return StringBinaryTag.of((String)charSequence);
    }

    private boolean separatorOrCompleteWith(char c2) {
        if (this.buffer.takeIf(c2)) {
            return true;
        }
        this.buffer.expect(',');
        return this.buffer.takeIf(c2);
    }

    private static String unescape(String string) {
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        do {
            stringBuilder.append(string, n3, n2);
        } while ((n2 = string.indexOf(92, (n3 = n2 + 1) + 1)) != -1);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public final void legacy(boolean bl2) {
        this.acceptLegacy = bl2;
    }
}

