/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.platform.facet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.extremall.advancedkits.libs.kyori.adventure.audience.Audience;
import me.extremall.advancedkits.libs.kyori.adventure.audience.ForwardingAudience;
import me.extremall.advancedkits.libs.kyori.adventure.identity.Identity;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.permission.PermissionChecker;
import me.extremall.advancedkits.libs.kyori.adventure.platform.AudienceProvider;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetAudience;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetPointers;
import me.extremall.advancedkits.libs.kyori.adventure.pointer.Pointered;
import me.extremall.advancedkits.libs.kyori.adventure.pointer.Pointers;
import me.extremall.advancedkits.libs.kyori.adventure.text.renderer.ComponentRenderer;
import me.extremall.advancedkits.libs.kyori.adventure.util.TriState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class FacetAudienceProvider<V, A extends FacetAudience<V>>
implements ForwardingAudience,
AudienceProvider {
    protected static final Locale DEFAULT_LOCALE = Locale.US;
    protected final ComponentRenderer<Pointered> componentRenderer;
    private final Audience console;
    private final Audience player;
    protected final Map<V, A> viewers;
    private final Map<UUID, A> players;
    private final Set<A> consoles;
    private A empty;
    private volatile boolean closed;

    protected FacetAudienceProvider(@NotNull ComponentRenderer<Pointered> componentRenderer) {
        this.componentRenderer = Objects.requireNonNull(componentRenderer, "component renderer");
        this.viewers = new ConcurrentHashMap<V, A>();
        this.players = new ConcurrentHashMap<UUID, A>();
        this.consoles = new CopyOnWriteArraySet<A>();
        this.console = new ForwardingAudience(){

            @Override
            @NotNull
            public Iterable<? extends Audience> audiences() {
                return FacetAudienceProvider.this.consoles;
            }

            @Override
            @NotNull
            public Pointers pointers() {
                if (FacetAudienceProvider.this.consoles.size() == 1) {
                    return ((FacetAudience)FacetAudienceProvider.this.consoles.iterator().next()).pointers();
                }
                return Pointers.empty();
            }
        };
        this.player = Audience.audience(this.players.values());
        this.closed = false;
    }

    public void addViewer(@NotNull V object2) {
        if (this.closed) {
            return;
        }
        Object object3 = (object2 = this.viewers.computeIfAbsent((FacetAudience)Objects.requireNonNull(object2, "viewer"), (Function<FacetAudience, A>)((Function<Object, FacetAudience>)object -> this.createAudience(Collections.singletonList(object))))).getOrDefault(FacetPointers.TYPE, FacetPointers.Type.OTHER);
        if (object3 == FacetPointers.Type.PLAYER) {
            object3 = object2.getOrDefault(Identity.UUID, null);
            if (object3 != null) {
                this.players.putIfAbsent((UUID)object3, object2);
            }
            return;
        }
        if (object3 == FacetPointers.Type.CONSOLE) {
            this.consoles.add(object2);
        }
    }

    public void removeViewer(@NotNull V object) {
        if ((object = (FacetAudience)this.viewers.remove(object)) == null) {
            return;
        }
        Object object2 = object.getOrDefault(FacetPointers.TYPE, (FacetPointers.Type)FacetPointers.Type.OTHER);
        if (object2 == FacetPointers.Type.PLAYER) {
            object2 = object.getOrDefault(Identity.UUID, null);
            if (object2 != null) {
                this.players.remove(object2);
            }
        } else if (object2 == FacetPointers.Type.CONSOLE) {
            this.consoles.remove(object);
        }
        ((FacetAudience)object).close();
    }

    public void refreshViewer(@NotNull V object) {
        if ((object = (FacetAudience)this.viewers.get(object)) != null) {
            ((FacetAudience)object).refresh();
        }
    }

    @NotNull
    protected abstract A createAudience(@NotNull Collection<V> var1);

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.viewers.values();
    }

    @Override
    @NotNull
    public Audience all() {
        return this;
    }

    @Override
    @NotNull
    public Audience console() {
        return this.console;
    }

    @Override
    @NotNull
    public Audience players() {
        return this.player;
    }

    @Override
    @NotNull
    public Audience player(@NotNull UUID uUID) {
        return (Audience)this.players.getOrDefault(uUID, this.empty());
    }

    @NotNull
    private A empty() {
        if (this.empty == null) {
            this.empty = this.createAudience(Collections.emptyList());
        }
        return this.empty;
    }

    @NotNull
    public Audience filter(@NotNull Predicate<V> predicate) {
        return Audience.audience(FacetAudienceProvider.filter(this.viewers.entrySet(), entry -> predicate.test(entry.getKey()), Map.Entry::getValue));
    }

    @NotNull
    private Audience filterPointers(@NotNull Predicate<Pointered> predicate) {
        return Audience.audience(FacetAudienceProvider.filter(this.viewers.entrySet(), entry -> predicate.test((Pointered)entry.getValue()), Map.Entry::getValue));
    }

    @Override
    @NotNull
    public Audience permission(@NotNull String string) {
        return this.filterPointers(pointered -> pointered.get(PermissionChecker.POINTER).orElse(PermissionChecker.always(TriState.FALSE)).test(string));
    }

    @Override
    @NotNull
    public Audience world(@NotNull Key key) {
        return this.filterPointers(pointered -> key.equals(pointered.getOrDefault(FacetPointers.WORLD, null)));
    }

    @Override
    @NotNull
    public Audience server(@NotNull String string) {
        return this.filterPointers(pointered -> string.equals(pointered.getOrDefault(FacetPointers.SERVER, null)));
    }

    @Override
    public void close() {
        this.closed = true;
        for (V v2 : this.viewers.keySet()) {
            this.removeViewer(v2);
        }
    }

    @NotNull
    private static <T, V> Iterable<V> filter(final @NotNull Iterable<T> iterable, final @NotNull Predicate<T> predicate, final @NotNull Function<T, V> function) {
        return new Iterable<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<T> parent;
                    private V next;
                    {
                        this.parent = iterable.iterator();
                        this.populate();
                    }

                    private void populate() {
                        this.next = null;
                        while (this.parent.hasNext()) {
                            Object t2 = this.parent.next();
                            if (!predicate.test(t2)) continue;
                            this.next = function.apply(t2);
                            return;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public V next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object v2 = this.next;
                        this.populate();
                        return v2;
                    }
                };
            }

            @Override
            public void forEach(Consumer<? super V> consumer) {
                for (Object t2 : iterable) {
                    if (!predicate.test(t2)) continue;
                    consumer.accept(function.apply(t2));
                }
            }
        };
    }
}

