/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.resource;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.resource.ResourcePackCallback;
import me.extremall.advancedkits.libs.kyori.adventure.resource.ResourcePackInfo;
import me.extremall.advancedkits.libs.kyori.adventure.resource.ResourcePackInfoLike;
import me.extremall.advancedkits.libs.kyori.adventure.resource.ResourcePackRequest;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.util.MonkeyBars;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourcePackRequestImpl
implements ResourcePackRequest {
    private final List<ResourcePackInfo> packs;
    private final ResourcePackCallback cb;
    private final boolean replace;
    private final boolean required;
    @Nullable
    private final Component prompt;

    ResourcePackRequestImpl(List<ResourcePackInfo> list, ResourcePackCallback resourcePackCallback, boolean bl2, boolean bl3, @Nullable Component component) {
        this.packs = list;
        this.cb = resourcePackCallback;
        this.replace = bl2;
        this.required = bl3;
        this.prompt = component;
    }

    @Override
    @NotNull
    public final List<ResourcePackInfo> packs() {
        return this.packs;
    }

    @Override
    @NotNull
    public final ResourcePackRequest packs(@NotNull Iterable<? extends ResourcePackInfoLike> iterable) {
        if (this.packs.equals(iterable)) {
            return this;
        }
        return new ResourcePackRequestImpl(MonkeyBars.toUnmodifiableList(ResourcePackInfoLike::asResourcePackInfo, iterable), this.cb, this.replace, this.required, this.prompt);
    }

    @Override
    @NotNull
    public final ResourcePackCallback callback() {
        return this.cb;
    }

    @Override
    @NotNull
    public final ResourcePackRequest callback(@NotNull ResourcePackCallback resourcePackCallback) {
        if (resourcePackCallback == this.cb) {
            return this;
        }
        return new ResourcePackRequestImpl(this.packs, Objects.requireNonNull(resourcePackCallback, "cb"), this.replace, this.required, this.prompt);
    }

    @Override
    public final boolean replace() {
        return this.replace;
    }

    @Override
    public final boolean required() {
        return this.required;
    }

    @Override
    @Nullable
    public final Component prompt() {
        return this.prompt;
    }

    @Override
    @NotNull
    public final ResourcePackRequest replace(boolean bl2) {
        if (bl2 == this.replace) {
            return this;
        }
        return new ResourcePackRequestImpl(this.packs, this.cb, bl2, this.required, this.prompt);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (ResourcePackRequestImpl)object;
        return this.replace == ((ResourcePackRequestImpl)object).replace && Objects.equals(this.packs, ((ResourcePackRequestImpl)object).packs) && Objects.equals(this.cb, ((ResourcePackRequestImpl)object).cb) && this.required == ((ResourcePackRequestImpl)object).required && Objects.equals(this.prompt, ((ResourcePackRequestImpl)object).prompt);
    }

    public final int hashCode() {
        return Objects.hash(this.packs, this.cb, this.replace, this.required, this.prompt);
    }

    @NotNull
    public final String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("packs", this.packs), ExaminableProperty.of("callback", this.cb), ExaminableProperty.of("replace", this.replace), ExaminableProperty.of("required", this.required), ExaminableProperty.of("prompt", this.prompt));
    }

    static final class BuilderImpl
    implements ResourcePackRequest.Builder {
        private List<ResourcePackInfo> packs;
        private ResourcePackCallback cb;
        private boolean replace;
        private boolean required;
        @Nullable
        private Component prompt;

        BuilderImpl() {
            this.packs = Collections.emptyList();
            this.cb = ResourcePackCallback.noOp();
            this.replace = false;
        }

        BuilderImpl(@NotNull ResourcePackRequest resourcePackRequest) {
            this.packs = resourcePackRequest.packs();
            this.cb = resourcePackRequest.callback();
            this.replace = resourcePackRequest.replace();
            this.required = resourcePackRequest.required();
            this.prompt = resourcePackRequest.prompt();
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder packs(@NotNull ResourcePackInfoLike resourcePackInfoLike, ResourcePackInfoLike ... resourcePackInfoLikeArray) {
            this.packs = MonkeyBars.nonEmptyArrayToList(ResourcePackInfoLike::asResourcePackInfo, resourcePackInfoLike, resourcePackInfoLikeArray);
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder packs(@NotNull Iterable<? extends ResourcePackInfoLike> iterable) {
            this.packs = MonkeyBars.toUnmodifiableList(ResourcePackInfoLike::asResourcePackInfo, iterable);
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder callback(@NotNull ResourcePackCallback resourcePackCallback) {
            this.cb = Objects.requireNonNull(resourcePackCallback, "cb");
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder replace(boolean bl2) {
            this.replace = bl2;
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder required(boolean bl2) {
            this.required = bl2;
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest.Builder prompt(@Nullable Component component) {
            this.prompt = component;
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackRequest build() {
            return new ResourcePackRequestImpl(this.packs, this.cb, this.replace, this.required, this.prompt);
        }
    }
}

