/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.builder.AbstractBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentBuilderApplicable;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentCompaction;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentIterator;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentIteratorFlag;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentIteratorType;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentLike;
import me.extremall.advancedkits.libs.kyori.adventure.text.EntityNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.EntityNBTComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.JoinConfiguration;
import me.extremall.advancedkits.libs.kyori.adventure.text.JoinConfigurationImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.KeybindComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.KeybindComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.PatternReplacementResult;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScoreComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScoreComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.SelectorComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.SelectorComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.StorageNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.StorageNBTComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextReplacementConfig;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextReplacementConfigImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextReplacementRenderer;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslatableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslatableComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.ClickEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEventSource;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.StyleBuilderApplicable;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.StyleGetter;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.StyleSetter;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextDecoration;
import me.extremall.advancedkits.libs.kyori.adventure.translation.Translatable;
import me.extremall.advancedkits.libs.kyori.adventure.util.ForwardingIterator;
import me.extremall.advancedkits.libs.kyori.adventure.util.IntFunction2;
import me.extremall.advancedkits.libs.kyori.adventure.util.MonkeyBars;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Component
extends ComponentBuilderApplicable,
ComponentLike,
HoverEventSource<Component>,
StyleGetter,
StyleSetter<Component>,
Examinable {
    public static final BiPredicate<? super Component, ? super Component> EQUALS = Objects::equals;
    public static final BiPredicate<? super Component, ? super Component> EQUALS_IDENTITY = (component, component2) -> component == component2;
    public static final Predicate<? super Component> IS_NOT_EMPTY = component -> component != Component.empty();

    @NotNull
    public static TextComponent empty() {
        return TextComponentImpl.EMPTY;
    }

    @NotNull
    public static TextComponent newline() {
        return TextComponentImpl.NEWLINE;
    }

    @NotNull
    public static TextComponent space() {
        return TextComponentImpl.SPACE;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent join(@NotNull ComponentLike componentLike, ComponentLike ... componentLikeArray) {
        return Component.join(componentLike, Arrays.asList(componentLikeArray));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent join(@NotNull ComponentLike componentLike, Iterable<? extends ComponentLike> iterable) {
        if ((componentLike = Component.join(JoinConfiguration.separator(componentLike), iterable)) instanceof TextComponent) {
            return (TextComponent)componentLike;
        }
        return (TextComponent)((TextComponent.Builder)Component.text().append((Component)componentLike)).build();
    }

    @Contract(pure=true)
    @NotNull
    public static Component join(@NotNull JoinConfiguration.Builder builder, ComponentLike ... componentLikeArray) {
        return Component.join(builder, Arrays.asList(componentLikeArray));
    }

    @Contract(pure=true)
    @NotNull
    public static Component join(@NotNull JoinConfiguration.Builder builder, @NotNull Iterable<? extends ComponentLike> iterable) {
        return JoinConfigurationImpl.join((JoinConfiguration)builder.build(), iterable);
    }

    @Contract(pure=true)
    @NotNull
    public static Component join(@NotNull JoinConfiguration joinConfiguration, ComponentLike ... componentLikeArray) {
        return Component.join(joinConfiguration, Arrays.asList(componentLikeArray));
    }

    @Contract(pure=true)
    @NotNull
    public static Component join(@NotNull JoinConfiguration joinConfiguration, @NotNull Iterable<? extends ComponentLike> iterable) {
        return JoinConfigurationImpl.join(joinConfiguration, iterable);
    }

    @NotNull
    public static Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent() {
        return Component.toComponent(Component.empty());
    }

    @NotNull
    public static Collector<Component, ? extends ComponentBuilder<?, ?>, Component> toComponent(@NotNull Component component) {
        return Collector.of(Component::text, (builder, component2) -> {
            if (component != Component.empty() && !builder.children().isEmpty()) {
                builder.append(component);
            }
            builder.append((Component)component2);
        }, (object, builder) -> {
            object = object.children();
            TextComponent.Builder builder2 = (TextComponent.Builder)Component.text().append((Iterable<ComponentLike>)object);
            if (!object.isEmpty()) {
                builder2.append(component);
            }
            builder2.append(builder.children());
            return builder2;
        }, ComponentBuilder::build, new Collector.Characteristics[0]);
    }

    @Contract(pure=true)
    public static @NotNull BlockNBTComponent.Builder blockNBT() {
        return new BlockNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BlockNBTComponent blockNBT(@NotNull Consumer<? super BlockNBTComponent.Builder> consumer) {
        return (BlockNBTComponent)AbstractBuilder.configureAndBuild(Component.blockNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static BlockNBTComponent blockNBT(@NotNull String string, @NotNull BlockNBTComponent.Pos pos) {
        return Component.blockNBT(string, false, pos);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static BlockNBTComponent blockNBT(@NotNull String string, boolean bl2, @NotNull BlockNBTComponent.Pos pos) {
        return Component.blockNBT(string, bl2, null, pos);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static BlockNBTComponent blockNBT(@NotNull String string, boolean bl2, @Nullable ComponentLike componentLike, @NotNull BlockNBTComponent.Pos pos) {
        return BlockNBTComponentImpl.create(Collections.emptyList(), Style.empty(), string, bl2, componentLike, pos);
    }

    @Contract(pure=true)
    public static @NotNull EntityNBTComponent.Builder entityNBT() {
        return new EntityNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static EntityNBTComponent entityNBT(@NotNull Consumer<? super EntityNBTComponent.Builder> consumer) {
        return (EntityNBTComponent)AbstractBuilder.configureAndBuild(Component.entityNBT(), consumer);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static EntityNBTComponent entityNBT(@NotNull String string, @NotNull String string2) {
        return (EntityNBTComponent)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(string)).selector(string2).build();
    }

    @Contract(pure=true)
    public static @NotNull KeybindComponent.Builder keybind() {
        return new KeybindComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static KeybindComponent keybind(@NotNull Consumer<? super KeybindComponent.Builder> consumer) {
        return (KeybindComponent)AbstractBuilder.configureAndBuild(Component.keybind(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull String string) {
        return Component.keybind(string, Style.empty());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull KeybindComponent.KeybindLike keybindLike) {
        return Component.keybind(Objects.requireNonNull(keybindLike, "keybind").asKeybind(), Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull String string, @NotNull Style style) {
        return KeybindComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull KeybindComponent.KeybindLike keybindLike, @NotNull Style style) {
        return KeybindComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), Objects.requireNonNull(keybindLike, "keybind").asKeybind());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull String string, @Nullable TextColor textColor) {
        return Component.keybind(string, Style.style(textColor));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull KeybindComponent.KeybindLike keybindLike, @Nullable TextColor textColor) {
        return Component.keybind(Objects.requireNonNull(keybindLike, "keybind").asKeybind(), Style.style(textColor));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull String string, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.keybind(string, Style.style(textColor, textDecorationArray));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull KeybindComponent.KeybindLike keybindLike, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.keybind(Objects.requireNonNull(keybindLike, "keybind").asKeybind(), Style.style(textColor, textDecorationArray));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull String string, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.keybind(string, Style.style(textColor, set));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static KeybindComponent keybind(@NotNull KeybindComponent.KeybindLike keybindLike, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.keybind(Objects.requireNonNull(keybindLike, "keybind").asKeybind(), Style.style(textColor, set));
    }

    @Contract(pure=true)
    public static @NotNull ScoreComponent.Builder score() {
        return new ScoreComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ScoreComponent score(@NotNull Consumer<? super ScoreComponent.Builder> consumer) {
        return (ScoreComponent)AbstractBuilder.configureAndBuild(Component.score(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ScoreComponent score(@NotNull String string, @NotNull String string2) {
        return Component.score(string, string2, null);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ScoreComponent score(@NotNull String string, @NotNull String string2, @Nullable String string3) {
        return ScoreComponentImpl.create(Collections.emptyList(), Style.empty(), string, string2, string3);
    }

    @Contract(pure=true)
    public static @NotNull SelectorComponent.Builder selector() {
        return new SelectorComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static SelectorComponent selector(@NotNull Consumer<? super SelectorComponent.Builder> consumer) {
        return (SelectorComponent)AbstractBuilder.configureAndBuild(Component.selector(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SelectorComponent selector(@NotNull String string) {
        return Component.selector(string, null);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static SelectorComponent selector(@NotNull String string, @Nullable ComponentLike componentLike) {
        return SelectorComponentImpl.create(Collections.emptyList(), Style.empty(), string, componentLike);
    }

    @Contract(pure=true)
    public static @NotNull StorageNBTComponent.Builder storageNBT() {
        return new StorageNBTComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static StorageNBTComponent storageNBT(@NotNull Consumer<? super StorageNBTComponent.Builder> consumer) {
        return (StorageNBTComponent)AbstractBuilder.configureAndBuild(Component.storageNBT(), consumer);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StorageNBTComponent storageNBT(@NotNull String string, @NotNull Key key) {
        return Component.storageNBT(string, false, key);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static StorageNBTComponent storageNBT(@NotNull String string, boolean bl2, @NotNull Key key) {
        return Component.storageNBT(string, bl2, null, key);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static StorageNBTComponent storageNBT(@NotNull String string, boolean bl2, @Nullable ComponentLike componentLike, @NotNull Key key) {
        return StorageNBTComponentImpl.create(Collections.emptyList(), Style.empty(), string, bl2, componentLike, key);
    }

    @Contract(pure=true)
    public static @NotNull TextComponent.Builder text() {
        return new TextComponentImpl.BuilderImpl();
    }

    @NotNull
    public static TextComponent textOfChildren(ComponentLike ... componentLikeArray) {
        if (componentLikeArray.length == 0) {
            return Component.empty();
        }
        return TextComponentImpl.create(Arrays.asList(componentLikeArray), Style.empty(), "");
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TextComponent text(@NotNull Consumer<? super TextComponent.Builder> consumer) {
        return (TextComponent)AbstractBuilder.configureAndBuild(Component.text(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string) {
        if (string.isEmpty()) {
            return Component.empty();
        }
        return Component.text(string, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string, @NotNull Style style) {
        return TextComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string, @Nullable TextColor textColor) {
        return Component.text(string, Style.style(textColor));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(string, Style.style(textColor, textDecorationArray));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(@NotNull String string, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(string, Style.style(textColor, set));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(boolean bl2) {
        return Component.text(String.valueOf(bl2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(boolean bl2, @NotNull Style style) {
        return Component.text(String.valueOf(bl2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(boolean bl2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(bl2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(boolean bl2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(bl2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(boolean bl2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(bl2), textColor, set);
    }

    @Contract(pure=true)
    @NotNull
    public static TextComponent text(char c2) {
        if (c2 == '\n') {
            return Component.newline();
        }
        if (c2 == ' ') {
            return Component.space();
        }
        return Component.text(String.valueOf(c2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(char c2, @NotNull Style style) {
        return Component.text(String.valueOf(c2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(char c2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(c2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(char c2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(c2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(char c2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(c2), textColor, set);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(double d2) {
        return Component.text(String.valueOf(d2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(double d2, @NotNull Style style) {
        return Component.text(String.valueOf(d2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(double d2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(d2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(double d2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(d2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(double d2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(d2), textColor, set);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(float f2) {
        return Component.text(String.valueOf(f2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(float f2, @NotNull Style style) {
        return Component.text(String.valueOf(f2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(float f2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(f2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(float f2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(f2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(float f2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(f2), textColor, set);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(int n2) {
        return Component.text(String.valueOf(n2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(int n2, @NotNull Style style) {
        return Component.text(String.valueOf(n2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(int n2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(n2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(int n2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(n2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(int n2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(n2), textColor, set);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TextComponent text(long l2) {
        return Component.text(String.valueOf(l2));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(long l2, @NotNull Style style) {
        return Component.text(String.valueOf(l2), style);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(long l2, @Nullable TextColor textColor) {
        return Component.text(String.valueOf(l2), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(long l2, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.text(String.valueOf(l2), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TextComponent text(long l2, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.text(String.valueOf(l2), textColor, set);
    }

    @Contract(pure=true)
    public static @NotNull TranslatableComponent.Builder translatable() {
        return new TranslatableComponentImpl.BuilderImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TranslatableComponent translatable(@NotNull Consumer<? super TranslatableComponent.Builder> consumer) {
        return (TranslatableComponent)AbstractBuilder.configureAndBuild(Component.translatable(), consumer);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string) {
        return Component.translatable(string, Style.empty());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2) {
        return Component.translatable(string, string2, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, Style.empty());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @NotNull Style style) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string, null, Collections.emptyList());
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @NotNull Style style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, @NotNull Style style) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string, string2, Collections.emptyList());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull Style style) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, style);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, StyleBuilderApplicable ... styleBuilderApplicableArray) {
        return Component.translatable(Objects.requireNonNull(string, "key"), string2, Style.style(styleBuilderApplicableArray));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull Iterable<StyleBuilderApplicable> iterable) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, Style.style(iterable));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, ComponentLike ... componentLikeArray) {
        return Component.translatable(string, string2, Style.empty(), componentLikeArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, componentLikeArray);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, @NotNull Style style, ComponentLike ... componentLikeArray) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string, string2, Objects.requireNonNull(componentLikeArray, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull Style style, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, style, componentLikeArray);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, @NotNull Style style, @NotNull List<? extends ComponentLike> list) {
        return TranslatableComponentImpl.create(Collections.emptyList(), style, string, string2, Objects.requireNonNull(list, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull Style style, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, style, list);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, @NotNull List<? extends ComponentLike> list, @NotNull Iterable<StyleBuilderApplicable> iterable) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Style.style(iterable), string, string2, Objects.requireNonNull(list, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull List<? extends ComponentLike> list, @NotNull Iterable<StyleBuilderApplicable> iterable) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, list, iterable);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable String string2, @NotNull List<? extends ComponentLike> list, StyleBuilderApplicable ... styleBuilderApplicableArray) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Style.style(styleBuilderApplicableArray), string, string2, Objects.requireNonNull(list, "args"));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable String string, @NotNull List<? extends ComponentLike> list, StyleBuilderApplicable ... styleBuilderApplicableArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), string, list, styleBuilderApplicableArray);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor) {
        return Component.translatable(string, Style.style(textColor));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.translatable(string, Style.style(textColor, textDecorationArray));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, textDecorationArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.translatable(string, Style.style(textColor, set));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, set);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, ComponentLike ... componentLikeArray) {
        return Component.translatable(string, Style.empty(), componentLikeArray);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), componentLikeArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @NotNull Style style, ComponentLike ... componentLikeArray) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string, null, Objects.requireNonNull(componentLikeArray, "args"));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @NotNull Style style, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style, componentLikeArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, ComponentLike ... componentLikeArray) {
        return Component.translatable(string, Style.style(textColor), componentLikeArray);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, componentLikeArray);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set, ComponentLike ... componentLikeArray) {
        return Component.translatable(string, Style.style(textColor, set), componentLikeArray);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set, ComponentLike ... componentLikeArray) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, set, componentLikeArray);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @NotNull List<? extends ComponentLike> list) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Style.empty(), string, null, Objects.requireNonNull(list, "args"));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), list);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @NotNull Style style, @NotNull List<? extends ComponentLike> list) {
        return TranslatableComponentImpl.create(Collections.emptyList(), Objects.requireNonNull(style, "style"), string, null, Objects.requireNonNull(list, "args"));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @NotNull Style style, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), style, list);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(string, Style.style(textColor), list);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, list);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull String string, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(string, Style.style(textColor, set), list);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static TranslatableComponent translatable(@NotNull Translatable translatable, @Nullable TextColor textColor, @NotNull Set<TextDecoration> set, @NotNull List<? extends ComponentLike> list) {
        return Component.translatable(Objects.requireNonNull(translatable, "translatable").translationKey(), textColor, set, list);
    }

    public @Unmodifiable @NotNull List<Component> children();

    @Contract(pure=true)
    @NotNull
    public Component children(@NotNull List<? extends ComponentLike> var1);

    default public boolean contains(@NotNull Component component) {
        return this.contains(component, EQUALS_IDENTITY);
    }

    default public boolean contains(@NotNull Component component, @NotNull BiPredicate<? super Component, ? super Component> biPredicate) {
        if (biPredicate.test(this, component)) {
            return true;
        }
        for (Component component22 : this.children()) {
            if (!component22.contains(component, biPredicate)) continue;
            return true;
        }
        HoverEvent<?> hoverEvent = this.hoverEvent();
        if (hoverEvent != null) {
            Component component22;
            component22 = hoverEvent.value();
            Component component3 = null;
            if (component22 instanceof Component) {
                component3 = (Component)hoverEvent.value();
            } else if (component22 instanceof HoverEvent.ShowEntity) {
                component3 = ((HoverEvent.ShowEntity)((Object)component22)).name();
            }
            if (component3 != null) {
                if (biPredicate.test(component, component3)) {
                    return true;
                }
                for (Component component22 : component3.children()) {
                    if (!component22.contains(component, biPredicate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void detectCycle(@NotNull Component component) {
        if (component.contains(this)) {
            throw new IllegalStateException("Component cycle detected between " + this + " and " + component);
        }
    }

    @Contract(pure=true)
    @NotNull
    default public Component append(@NotNull Component component) {
        return this.append((ComponentLike)component);
    }

    @NotNull
    default public Component append(@NotNull ComponentLike componentLike) {
        Objects.requireNonNull(componentLike, "like");
        componentLike = componentLike.asComponent();
        Objects.requireNonNull(componentLike, "component");
        if (componentLike == Component.empty()) {
            return this;
        }
        List<Component> list = this.children();
        return this.children(MonkeyBars.addOne(list, componentLike));
    }

    @Contract(pure=true)
    @NotNull
    default public Component append(@NotNull ComponentBuilder<?, ?> componentBuilder) {
        return this.append((Component)componentBuilder.build());
    }

    @Contract(pure=true)
    @NotNull
    default public Component appendNewline() {
        return this.append(Component.newline());
    }

    @Contract(pure=true)
    @NotNull
    default public Component appendSpace() {
        return this.append(Component.space());
    }

    @Contract(pure=true)
    @NotNull
    default public Component applyFallbackStyle(@NotNull Style style) {
        Objects.requireNonNull(style, "style");
        Component component = this;
        return component.style(component.style().merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET));
    }

    @Contract(pure=true)
    @NotNull
    default public Component applyFallbackStyle(StyleBuilderApplicable ... styleBuilderApplicableArray) {
        return this.applyFallbackStyle(Style.style(styleBuilderApplicableArray));
    }

    @NotNull
    public Style style();

    @Contract(pure=true)
    @NotNull
    public Component style(@NotNull Style var1);

    @Contract(pure=true)
    @NotNull
    default public Component style(@NotNull Consumer<Style.Builder> consumer) {
        Component component = this;
        return component.style(component.style().edit(consumer));
    }

    @Contract(pure=true)
    @NotNull
    default public Component style(@NotNull Consumer<Style.Builder> consumer, @NotNull Style.Merge.Strategy strategy) {
        Component component = this;
        return component.style(component.style().edit(consumer, strategy));
    }

    @Contract(pure=true)
    @NotNull
    default public Component style(@NotNull Style.Builder builder) {
        return this.style(builder.build());
    }

    @Contract(pure=true)
    @NotNull
    default public Component mergeStyle(@NotNull Component component) {
        return this.mergeStyle(component, Style.Merge.all());
    }

    @Contract(pure=true)
    @NotNull
    default public Component mergeStyle(@NotNull Component component, Style.Merge ... mergeArray) {
        return this.mergeStyle(component, Style.Merge.merges(mergeArray));
    }

    @Contract(pure=true)
    @NotNull
    default public Component mergeStyle(@NotNull Component component, @NotNull Set<Style.Merge> set) {
        Component component2 = this;
        return component2.style(component2.style().merge(component.style(), set));
    }

    @Override
    @Nullable
    default public Key font() {
        return this.style().font();
    }

    @Override
    @NotNull
    default public Component font(@Nullable Key key) {
        Component component = this;
        return component.style(component.style().font(key));
    }

    @Override
    @Nullable
    default public TextColor color() {
        return this.style().color();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component color(@Nullable TextColor textColor) {
        Component component = this;
        return component.style(component.style().color(textColor));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component colorIfAbsent(@Nullable TextColor textColor) {
        if (this.color() == null) {
            return this.color(textColor);
        }
        return this;
    }

    @Override
    default public boolean hasDecoration(@NotNull TextDecoration textDecoration) {
        return StyleGetter.super.hasDecoration(textDecoration);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decorate(@NotNull TextDecoration textDecoration) {
        return (Component)StyleSetter.super.decorate(textDecoration);
    }

    @Override
    default public @NotNull TextDecoration.State decoration(@NotNull TextDecoration textDecoration) {
        return this.style().decoration(textDecoration);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decoration(@NotNull TextDecoration textDecoration, boolean bl2) {
        return (Component)StyleSetter.super.decoration(textDecoration, bl2);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        Component component = this;
        return component.style(component.style().decoration(textDecoration, state));
    }

    @Override
    @NotNull
    default public Component decorationIfAbsent(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        @NotNull TextDecoration.State state2 = this.decoration(textDecoration);
        if (state2 == TextDecoration.State.NOT_SET) {
            Component component = this;
            return component.style(component.style().decoration(textDecoration, state));
        }
        return this;
    }

    @Override
    @NotNull
    default public Map<TextDecoration, TextDecoration.State> decorations() {
        return this.style().decorations();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component decorations(@NotNull Map<TextDecoration, TextDecoration.State> map) {
        Component component = this;
        return component.style((Style)component.style().decorations((Map)map));
    }

    @Override
    @Nullable
    default public ClickEvent clickEvent() {
        return this.style().clickEvent();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component clickEvent(@Nullable ClickEvent clickEvent) {
        Component component = this;
        return component.style(component.style().clickEvent(clickEvent));
    }

    @Override
    @Nullable
    default public HoverEvent<?> hoverEvent() {
        return this.style().hoverEvent();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
        Component component = this;
        return component.style((Style)component.style().hoverEvent((HoverEventSource)hoverEventSource));
    }

    @Override
    @Nullable
    default public String insertion() {
        return this.style().insertion();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public Component insertion(@Nullable String string) {
        Component component = this;
        return component.style(component.style().insertion(string));
    }

    default public boolean hasStyling() {
        return !this.style().isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Consumer<TextReplacementConfig.Builder> consumer) {
        Objects.requireNonNull(consumer, "configurer");
        return this.replaceText((TextReplacementConfig)AbstractBuilder.configureAndBuild(TextReplacementConfig.builder(), consumer));
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull TextReplacementConfig textReplacementConfig) {
        Objects.requireNonNull(textReplacementConfig, "replacement");
        if (!(textReplacementConfig instanceof TextReplacementConfigImpl)) {
            throw new IllegalArgumentException("Provided replacement was a custom TextReplacementConfig implementation, which is not supported.");
        }
        return TextReplacementRenderer.INSTANCE.render(this, ((TextReplacementConfigImpl)textReplacementConfig).createState());
    }

    @NotNull
    default public Component compact() {
        return ComponentCompaction.compact(this, null);
    }

    @NotNull
    default public Iterable<Component> iterable(@NotNull ComponentIteratorType componentIteratorType, ComponentIteratorFlag ... componentIteratorFlagArray) {
        return this.iterable(componentIteratorType, componentIteratorFlagArray == null ? Collections.emptySet() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])componentIteratorFlagArray));
    }

    @NotNull
    default public Iterable<Component> iterable(@NotNull ComponentIteratorType componentIteratorType, @NotNull Set<ComponentIteratorFlag> set) {
        Objects.requireNonNull(componentIteratorType, "type");
        Objects.requireNonNull(set, "flags");
        return new ForwardingIterator<Component>(() -> this.iterator(componentIteratorType, set), () -> this.spliterator(componentIteratorType, set));
    }

    @NotNull
    default public Iterator<Component> iterator(@NotNull ComponentIteratorType componentIteratorType, ComponentIteratorFlag ... componentIteratorFlagArray) {
        return this.iterator(componentIteratorType, componentIteratorFlagArray == null ? Collections.emptySet() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])componentIteratorFlagArray));
    }

    @NotNull
    default public Iterator<Component> iterator(@NotNull ComponentIteratorType componentIteratorType, @NotNull Set<ComponentIteratorFlag> set) {
        return new ComponentIterator(this, Objects.requireNonNull(componentIteratorType, "type"), Objects.requireNonNull(set, "flags"));
    }

    @NotNull
    default public Spliterator<Component> spliterator(@NotNull ComponentIteratorType componentIteratorType, ComponentIteratorFlag ... componentIteratorFlagArray) {
        return this.spliterator(componentIteratorType, componentIteratorFlagArray == null ? Collections.emptySet() : MonkeyBars.enumSet(ComponentIteratorFlag.class, (Enum[])componentIteratorFlagArray));
    }

    @NotNull
    default public Spliterator<Component> spliterator(@NotNull ComponentIteratorType componentIteratorType, @NotNull Set<ComponentIteratorFlag> set) {
        return Spliterators.spliteratorUnknownSize(this.iterator(componentIteratorType, set), 1296);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull String string, @Nullable ComponentLike componentLike) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.matchLiteral(string).replacement(componentLike));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Pattern pattern, @NotNull Function<TextComponent.Builder, @Nullable ComponentLike> function) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.match(pattern).replacement(function));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceFirstText(@NotNull String string, @Nullable ComponentLike componentLike) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.matchLiteral(string).once().replacement(componentLike));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceFirstText(@NotNull Pattern pattern, @NotNull Function<TextComponent.Builder, @Nullable ComponentLike> function) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.match(pattern).once().replacement(function));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull String string, @Nullable ComponentLike componentLike, int n2) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.matchLiteral(string).times(n2).replacement(componentLike));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Pattern pattern, @NotNull Function<TextComponent.Builder, @Nullable ComponentLike> function, int n2) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.match(pattern).times(n2).replacement(function));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull String string, @Nullable ComponentLike componentLike, @NotNull IntFunction2<PatternReplacementResult> intFunction2) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.matchLiteral(string).replacement(componentLike).condition(intFunction2));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Pattern pattern, @NotNull Function<TextComponent.Builder, @Nullable ComponentLike> function, @NotNull IntFunction2<PatternReplacementResult> intFunction2) {
        return this.replaceText((TextReplacementConfig.Builder builder) -> builder.match(pattern).replacement(function).condition(intFunction2));
    }

    @Override
    default public void componentBuilderApply(@NotNull ComponentBuilder<?, ?> componentBuilder) {
        componentBuilder.append(this);
    }

    @Override
    @NotNull
    default public Component asComponent() {
        return this;
    }

    @Override
    @NotNull
    default public HoverEvent<Component> asHoverEvent(@NotNull UnaryOperator<Component> unaryOperator) {
        return HoverEvent.showText((Component)unaryOperator.apply(this));
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("style", this.style()), ExaminableProperty.of("children", this.children()));
    }
}

