/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.Objects;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslationArgument;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TranslationArgumentImpl
implements TranslationArgument {
    private static final Component TRUE = Component.text("true");
    private static final Component FALSE = Component.text("false");
    private final Object value;

    TranslationArgumentImpl(Object object) {
        this.value = object;
    }

    @Override
    @NotNull
    public final Object value() {
        return this.value;
    }

    @Override
    @NotNull
    public final Component asComponent() {
        if (this.value instanceof Component) {
            return (Component)this.value;
        }
        if (this.value instanceof Boolean) {
            if (((Boolean)this.value).booleanValue()) {
                return TRUE;
            }
            return FALSE;
        }
        return Component.text(String.valueOf(this.value));
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (TranslationArgumentImpl)object;
        return Objects.equals(this.value, ((TranslationArgumentImpl)object).value);
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }
}

