/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.flattener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.KeybindComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScoreComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.SelectorComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TranslatableComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.flattener.ComponentFlattener;
import me.extremall.advancedkits.libs.kyori.adventure.text.flattener.FlattenerListener;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentFlattenerImpl
implements ComponentFlattener {
    static final ComponentFlattener BASIC = (ComponentFlattener)new BuilderImpl().mapper(KeybindComponent.class, keybindComponent -> keybindComponent.keybind()).mapper(ScoreComponent.class, object -> {
        if ((object = object.value()) != null) {
            return object;
        }
        return "";
    }).mapper(SelectorComponent.class, SelectorComponent::pattern).mapper(TextComponent.class, TextComponent::content).mapper(TranslatableComponent.class, translatableComponent -> {
        @Nullable String string = translatableComponent.fallback();
        if (string != null) {
            return string;
        }
        return translatableComponent.key();
    }).build();
    static final ComponentFlattener TEXT_ONLY = (ComponentFlattener)new BuilderImpl().mapper(TextComponent.class, TextComponent::content).build();
    private static final int MAX_DEPTH = 512;
    private final Map<Class<?>, Function<?, String>> flatteners;
    private final Map<Class<?>, BiConsumer<?, Consumer<Component>>> complexFlatteners;
    private final ConcurrentMap<Class<?>, Handler> propagatedFlatteners = new ConcurrentHashMap();
    private final Function<Component, String> unknownHandler;

    ComponentFlattenerImpl(Map<Class<?>, Function<?, String>> map, Map<Class<?>, BiConsumer<?, Consumer<Component>>> map2, @Nullable Function<Component, String> function) {
        this.flatteners = Collections.unmodifiableMap(new HashMap(map));
        this.complexFlatteners = Collections.unmodifiableMap(new HashMap(map2));
        this.unknownHandler = function;
    }

    @Override
    public final void flatten(@NotNull Component component, @NotNull FlattenerListener flattenerListener) {
        this.flatten0(component, flattenerListener, 0);
    }

    private void flatten0(@NotNull Component object, @NotNull FlattenerListener flattenerListener, int n2) {
        Objects.requireNonNull(object, "input");
        Objects.requireNonNull(flattenerListener, "listener");
        if (object == Component.empty()) {
            return;
        }
        if (n2 > 512) {
            throw new IllegalStateException("Exceeded maximum depth of 512 while attempting to flatten components!");
        }
        @Nullable Handler object22 = this.flattener((Component)((Object)object));
        Style style = object.style();
        flattenerListener.pushStyle(style);
        try {
            if (object22 != null) {
                object22.handle((Component)((Object)object), flattenerListener, n2 + 1);
            }
            if (!object.children().isEmpty() && flattenerListener.shouldContinue()) {
                for (Component component : object.children()) {
                    this.flatten0(component, flattenerListener, n2 + 1);
                }
            }
            return;
        }
        finally {
            flattenerListener.popStyle(style);
        }
    }

    @Nullable
    private <T extends Component> Handler flattener(T object) {
        if ((object = this.propagatedFlatteners.computeIfAbsent(object.getClass(), clazz -> {
            @Nullable Function<?, String> object3 = this.flatteners.get(clazz);
            if (object3 != null) {
                return (component, flattenerListener, n2) -> flattenerListener.component((String)object3.apply(component));
            }
            for (Map.Entry<Class<?>, Function<?, String>> entry : this.flatteners.entrySet()) {
                if (!entry.getKey().isAssignableFrom((Class<?>)clazz)) continue;
                return (component, flattenerListener, n2) -> flattenerListener.component((String)((Function)entry.getValue()).apply(component));
            }
            @Nullable @Nullable BiConsumer<?, Consumer<Component>> biConsumer = this.complexFlatteners.get(clazz);
            if (biConsumer != null) {
                return (component2, flattenerListener, n2) -> object3.accept(component2, component -> this.flatten0((Component)component, flattenerListener, n2));
            }
            for (Map.Entry<Class<?>, BiConsumer<?, Consumer<Component>>> entry : this.complexFlatteners.entrySet()) {
                if (!entry.getKey().isAssignableFrom((Class<?>)clazz)) continue;
                return (component2, flattenerListener, n2) -> ((BiConsumer)entry.getValue()).accept(component2, component -> this.flatten0((Component)component, flattenerListener, n2));
            }
            return Handler.NONE;
        })) == Handler.NONE) {
            if (this.unknownHandler == null) {
                return null;
            }
            return (component, flattenerListener, n2) -> flattenerListener.component(this.unknownHandler.apply(component));
        }
        return object;
    }

    @Override
    public final @NotNull ComponentFlattener.Builder toBuilder() {
        return new BuilderImpl(this.flatteners, this.complexFlatteners, this.unknownHandler);
    }

    static final class BuilderImpl
    implements ComponentFlattener.Builder {
        private final Map<Class<?>, Function<?, String>> flatteners;
        private final Map<Class<?>, BiConsumer<?, Consumer<Component>>> complexFlatteners;
        @Nullable
        private Function<Component, String> unknownHandler;

        BuilderImpl() {
            this.flatteners = new HashMap();
            this.complexFlatteners = new HashMap();
        }

        BuilderImpl(Map<Class<?>, Function<?, String>> map, Map<Class<?>, BiConsumer<?, Consumer<Component>>> map2, @Nullable Function<Component, String> function) {
            this.flatteners = new HashMap(map);
            this.complexFlatteners = new HashMap(map2);
            this.unknownHandler = function;
        }

        @Override
        @NotNull
        public final ComponentFlattener build() {
            return new ComponentFlattenerImpl(this.flatteners, this.complexFlatteners, this.unknownHandler);
        }

        @Override
        public final <T extends Component> @NotNull ComponentFlattener.Builder mapper(@NotNull Class<T> clazz, @NotNull Function<T, String> function) {
            this.validateNoneInHierarchy(Objects.requireNonNull(clazz, "type"));
            this.flatteners.put(clazz, Objects.requireNonNull(function, "converter"));
            this.complexFlatteners.remove(clazz);
            return this;
        }

        @Override
        public final <T extends Component> @NotNull ComponentFlattener.Builder complexMapper(@NotNull Class<T> clazz, @NotNull BiConsumer<T, Consumer<Component>> biConsumer) {
            this.validateNoneInHierarchy(Objects.requireNonNull(clazz, "type"));
            this.complexFlatteners.put(clazz, Objects.requireNonNull(biConsumer, "converter"));
            this.flatteners.remove(clazz);
            return this;
        }

        private void validateNoneInHierarchy(Class<? extends Component> clazz) {
            for (Class<?> clazz2 : this.flatteners.keySet()) {
                BuilderImpl.testHierarchy(clazz2, clazz);
            }
            for (Class<?> clazz2 : this.complexFlatteners.keySet()) {
                BuilderImpl.testHierarchy(clazz2, clazz);
            }
        }

        private static void testHierarchy(Class<?> clazz, Class<?> clazz2) {
            if (!clazz.equals(clazz2) && (clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz))) {
                throw new IllegalArgumentException("Conflict detected between already registered type " + clazz + " and newly registered type " + clazz2 + "! Types in a component flattener must not share a common hierarchy!");
            }
        }

        @Override
        public final @NotNull ComponentFlattener.Builder unknownMapper(@Nullable Function<Component, String> function) {
            this.unknownHandler = function;
            return this;
        }
    }

    @FunctionalInterface
    static interface Handler {
        public static final Handler NONE = (component, flattenerListener, n2) -> {};

        public void handle(Component var1, FlattenerListener var2, int var3);
    }
}

