/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.Context;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Tag;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import me.extremall.advancedkits.libs.kyori.adventure.util.HSVLike;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RainbowTag
extends AbstractColorChangingTag {
    private static final String REVERSE = "!";
    private static final String RAINBOW = "rainbow";
    static final TagResolver RESOLVER = TagResolver.resolver("rainbow", RainbowTag::create);
    private final boolean reversed;
    private final int phase;
    private int colorIndex = 0;

    static Tag create(ArgumentQueue object, Context context) {
        boolean bl2 = false;
        int n2 = 0;
        if (object.hasNext()) {
            if (((String)(object = object.pop().value())).startsWith(REVERSE)) {
                bl2 = true;
                object = ((String)object).substring(1);
            }
            if (((String)object).length() > 0) {
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw context.newException("Expected phase, got " + (String)object);
                }
            }
        }
        return new RainbowTag(bl2, n2);
    }

    private RainbowTag(boolean bl2, int n2) {
        this.reversed = bl2;
        this.phase = n2;
    }

    @Override
    protected final void init() {
        if (this.reversed) {
            this.colorIndex = this.size() - 1;
        }
    }

    @Override
    protected final void advanceColor() {
        if (this.reversed) {
            if (this.colorIndex == 0) {
                this.colorIndex = this.size() - 1;
                return;
            }
            --this.colorIndex;
            return;
        }
        ++this.colorIndex;
    }

    @Override
    protected final TextColor color() {
        float f2 = this.colorIndex;
        f2 = (f2 / (float)this.size() + (float)this.phase / 10.0f) % 1.0f;
        return TextColor.color(HSVLike.hsvLike(f2, 1.0f, 1.0f));
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (RainbowTag)object;
        return this.colorIndex == ((RainbowTag)object).colorIndex && this.phase == ((RainbowTag)object).phase;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.colorIndex, this.phase);
    }
}

