/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.NamedTextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.Context;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Inserting;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Tag;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class TransitionTag
implements Inserting,
Examinable {
    public static final String TRANSITION = "transition";
    private final TextColor[] colors;
    private final float phase;
    private final boolean negativePhase;
    static final TagResolver RESOLVER = TagResolver.resolver("transition", TransitionTag::create);

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        List<TextColor> list;
        float f2 = 0.0f;
        if (argumentQueue.hasNext()) {
            list = new ArrayList();
            while (argumentQueue.hasNext()) {
                Object object;
                Object object2 = argumentQueue.pop();
                if (!argumentQueue.hasNext() && ((OptionalDouble)(object = object2.asDouble())).isPresent()) {
                    f2 = (float)((OptionalDouble)object).getAsDouble();
                    if (!(f2 < -1.0f) && !(f2 > 1.0f)) break;
                    throw context.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(f2)), argumentQueue);
                }
                object = object2.value();
                if ((object2 = ((String)object).charAt(0) == '#' ? TextColor.fromHexString((String)object) : (TextColor)NamedTextColor.NAMES.value(object2.lowerValue())) == null) {
                    throw context.newException(String.format("Unable to parse a color from '%s'. Please use named colors or hex (#RRGGBB) colors.", object), argumentQueue);
                }
                list.add((TextColor)object2);
            }
            if (list.size() < 2) {
                throw context.newException("Invalid transition, not enough colors. Transitions must have at least two colors.", argumentQueue);
            }
        } else {
            list = Collections.emptyList();
        }
        return new TransitionTag(f2, list);
    }

    private TransitionTag(float f2, List<TextColor> list) {
        if (f2 < 0.0f) {
            this.negativePhase = true;
            this.phase = f2 + 1.0f;
            Collections.reverse(list);
        } else {
            this.negativePhase = false;
            this.phase = f2;
        }
        if (list.isEmpty()) {
            this.colors = new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)};
            return;
        }
        this.colors = list.toArray(new TextColor[0]);
    }

    @Override
    @NotNull
    public final Component value() {
        return Component.text("", this.color());
    }

    private TextColor color() {
        float f2 = 1.0f / (float)(this.colors.length - 1);
        for (int i2 = 1; i2 < this.colors.length; ++i2) {
            float f3;
            float f4 = (float)i2 * f2;
            if (!(f3 >= this.phase)) continue;
            f2 = 1.0f + (this.phase - f4) * (float)(this.colors.length - 1);
            if (this.negativePhase) {
                return TextColor.lerp(1.0f - f2, this.colors[i2], this.colors[i2 - 1]);
            }
            return TextColor.lerp(f2, this.colors[i2 - 1], this.colors[i2]);
        }
        return this.colors[0];
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (TransitionTag)object;
        return this.phase == ((TransitionTag)object).phase && Arrays.equals(this.colors, ((TransitionTag)object).colors);
    }

    public final int hashCode() {
        int n2 = Objects.hash(Float.valueOf(this.phase));
        n2 = n2 * 31 + Arrays.hashCode(this.colors);
        return n2;
    }
}

