/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.TypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.ClickEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextDecoration;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.BlockNBTComponentPosSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.ClickEventActionSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.HoverEventActionSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.KeySerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.ShowEntitySerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.ShowItemSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.StyleSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.TextColorSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.TextColorWrapper;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.TextDecorationSerializer;
import org.jetbrains.annotations.Nullable;

final class SerializerFactory
implements TypeAdapterFactory {
    static final Class<Key> KEY_TYPE = Key.class;
    static final Class<Component> COMPONENT_TYPE = Component.class;
    static final Class<Style> STYLE_TYPE = Style.class;
    static final Class<ClickEvent.Action> CLICK_ACTION_TYPE = ClickEvent.Action.class;
    static final Class<HoverEvent.Action> HOVER_ACTION_TYPE = HoverEvent.Action.class;
    static final Class<HoverEvent.ShowItem> SHOW_ITEM_TYPE = HoverEvent.ShowItem.class;
    static final Class<HoverEvent.ShowEntity> SHOW_ENTITY_TYPE = HoverEvent.ShowEntity.class;
    static final Class<TextColorWrapper> COLOR_WRAPPER_TYPE = TextColorWrapper.class;
    static final Class<TextColor> COLOR_TYPE = TextColor.class;
    static final Class<TextDecoration> TEXT_DECORATION_TYPE = TextDecoration.class;
    static final Class<BlockNBTComponent.Pos> BLOCK_NBT_POS_TYPE = BlockNBTComponent.Pos.class;
    private final boolean downsampleColors;
    private final LegacyHoverEventSerializer legacyHoverSerializer;
    private final boolean emitLegacyHover;

    SerializerFactory(boolean bl2, @Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl3) {
        this.downsampleColors = bl2;
        this.legacyHoverSerializer = legacyHoverEventSerializer;
        this.emitLegacyHover = bl3;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> object) {
        if (COMPONENT_TYPE.isAssignableFrom((Class<?>)(object = ((TypeToken)object).getRawType()))) {
            return ComponentSerializerImpl.create(gson);
        }
        if (KEY_TYPE.isAssignableFrom((Class<?>)object)) {
            return KeySerializer.INSTANCE;
        }
        if (STYLE_TYPE.isAssignableFrom((Class<?>)object)) {
            return StyleSerializer.create(this.legacyHoverSerializer, this.emitLegacyHover, gson);
        }
        if (CLICK_ACTION_TYPE.isAssignableFrom((Class<?>)object)) {
            return ClickEventActionSerializer.INSTANCE;
        }
        if (HOVER_ACTION_TYPE.isAssignableFrom((Class<?>)object)) {
            return HoverEventActionSerializer.INSTANCE;
        }
        if (SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)object)) {
            return ShowItemSerializer.create(gson);
        }
        if (SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)object)) {
            return ShowEntitySerializer.create(gson);
        }
        if (COLOR_WRAPPER_TYPE.isAssignableFrom((Class<?>)object)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (COLOR_TYPE.isAssignableFrom((Class<?>)object)) {
            if (this.downsampleColors) {
                return TextColorSerializer.DOWNSAMPLE_COLOR;
            }
            return TextColorSerializer.INSTANCE;
        }
        if (TEXT_DECORATION_TYPE.isAssignableFrom((Class<?>)object)) {
            return TextDecorationSerializer.INSTANCE;
        }
        if (BLOCK_NBT_POS_TYPE.isAssignableFrom((Class<?>)object)) {
            return BlockNBTComponentPosSerializer.INSTANCE;
        }
        return null;
    }
}

