/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import java.util.UUID;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.SerializerFactory;

final class ShowEntitySerializer
extends TypeAdapter<HoverEvent.ShowEntity> {
    static final String TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";
    private final Gson gson;

    static TypeAdapter<HoverEvent.ShowEntity> create(Gson gson) {
        return new ShowEntitySerializer(gson).nullSafe();
    }

    private ShowEntitySerializer(Gson gson) {
        this.gson = gson;
    }

    @Override
    public final HoverEvent.ShowEntity read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        UUID uUID = null;
        Component component = null;
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals(TYPE)) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (string.equals(ID)) {
                uUID = UUID.fromString(jsonReader.nextString());
                continue;
            }
            if (string.equals(NAME)) {
                component = (Component)this.gson.fromJson(jsonReader, SerializerFactory.COMPONENT_TYPE);
                continue;
            }
            jsonReader.skipValue();
        }
        if (key == null || uUID == null) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        jsonReader.endObject();
        return HoverEvent.ShowEntity.of(key, uUID, component);
    }

    @Override
    public final void write(JsonWriter jsonWriter, HoverEvent.ShowEntity examinable) {
        jsonWriter.beginObject();
        jsonWriter.name(TYPE);
        this.gson.toJson((Object)examinable.type(), SerializerFactory.KEY_TYPE, jsonWriter);
        jsonWriter.name(ID);
        jsonWriter.value(examinable.id().toString());
        examinable = examinable.name();
        if (examinable != null) {
            jsonWriter.name(NAME);
            this.gson.toJson((Object)examinable, SerializerFactory.COMPONENT_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }
}

