/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonObject;
import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.ClickEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextDecoration;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.SerializerFactory;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.TextColorWrapper;
import me.extremall.advancedkits.libs.kyori.adventure.util.Codec;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitLegacyHover;
    private final Gson gson;

    static TypeAdapter<Style> create(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl2, Gson gson) {
        return new StyleSerializer(legacyHoverEventSerializer, bl2, gson).nullSafe();
    }

    private StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl2, Gson gson) {
        this.legacyHover = legacyHoverEventSerializer;
        this.emitLegacyHover = bl2;
        this.gson = gson;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Style read(JsonReader var1_1) {
        var1_1.beginObject();
        var2_2 = Style.style();
        while (var1_1.hasNext()) {
            block21: {
                block23: {
                    block22: {
                        var3_3 = var1_1.nextName();
                        if (var3_3.equals("font")) {
                            var2_2.font((Key)this.gson.fromJson(var1_1, SerializerFactory.KEY_TYPE));
                            continue;
                        }
                        if (var3_3.equals("color")) {
                            var3_3 = (TextColorWrapper)this.gson.fromJson(var1_1, SerializerFactory.COLOR_WRAPPER_TYPE);
                            if (var3_3.color != null) {
                                var2_2.color(var3_3.color);
                                continue;
                            }
                            if (var3_3.decoration == null) continue;
                            var2_2.decoration(var3_3.decoration, TextDecoration.State.TRUE);
                            continue;
                        }
                        if (TextDecoration.NAMES.keys().contains(var3_3)) {
                            var2_2.decoration(TextDecoration.NAMES.value((String)var3_3), this.readBoolean(var1_1));
                            continue;
                        }
                        if (var3_3.equals("insertion")) {
                            var2_2.insertion(var1_1.nextString());
                            continue;
                        }
                        if (var3_3.equals("clickEvent")) {
                            var1_1.beginObject();
                            var3_3 = null;
                            var4_4 = null;
                            while (var1_1.hasNext()) {
                                var5_5 = var1_1.nextName();
                                if (var5_5.equals("action")) {
                                    var3_3 = (ClickEvent.Action)this.gson.fromJson(var1_1, SerializerFactory.CLICK_ACTION_TYPE);
                                    continue;
                                }
                                if (var5_5.equals("value")) {
                                    var4_4 = var1_1.peek() == JsonToken.NULL ? null : var1_1.nextString();
                                    continue;
                                }
                                var1_1.skipValue();
                            }
                            if (var3_3 != null && var3_3.readable() && var4_4 != null) {
                                var2_2.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)var3_3, (String)var4_4));
                            }
                            var1_1.endObject();
                            continue;
                        }
                        if (!var3_3.equals("hoverEvent")) break block21;
                        var3_3 = (JsonObject)this.gson.fromJson(var1_1, (Type)JsonObject.class);
                        if (var3_3 == null || (var4_4 = var3_3.getAsJsonPrimitive("action")) == null || !(var5_5 = this.gson.fromJson((JsonElement)var4_4, SerializerFactory.HOVER_ACTION_TYPE)).readable()) continue;
                        if (!var3_3.has("contents")) break block22;
                        var3_3 = var3_3.get("contents");
                        var4_4 = var5_5.type();
                        if (StyleSerializer.isNullOrEmpty((JsonElement)var3_3)) ** GOTO lbl-1000
                        if (SerializerFactory.COMPONENT_TYPE.isAssignableFrom((Class<?>)var4_4)) {
                            var3_3 = this.gson.fromJson((JsonElement)var3_3, SerializerFactory.COMPONENT_TYPE);
                        } else if (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)var4_4)) {
                            var3_3 = this.gson.fromJson((JsonElement)var3_3, SerializerFactory.SHOW_ITEM_TYPE);
                        } else if (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)var4_4)) {
                            var3_3 = this.gson.fromJson((JsonElement)var3_3, SerializerFactory.SHOW_ENTITY_TYPE);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = null;
                        }
                        break block23;
                    }
                    if (var3_3.has("value")) {
                        if (StyleSerializer.isNullOrEmpty((JsonElement)(var3_3 = var3_3.get("value")))) {
                            var3_3 = null;
                        } else {
                            var4_4 = this.gson.fromJson((JsonElement)var3_3, SerializerFactory.COMPONENT_TYPE);
                            var3_3 = this.legacyHoverEventContents((HoverEvent.Action<?>)var5_5, (Component)var4_4);
                        }
                    } else {
                        var3_3 = null;
                    }
                }
                if (var3_3 == null) continue;
                var2_2.hoverEvent(HoverEvent.hoverEvent(var5_5, var3_3));
                continue;
            }
            var1_1.skipValue();
        }
        var1_1.endObject();
        return var2_2.build();
    }

    private static boolean isNullOrEmpty(@Nullable JsonElement jsonElement) {
        return jsonElement == null || jsonElement.isJsonNull() || jsonElement.isJsonArray() && jsonElement.getAsJsonArray().size() == 0 || jsonElement.isJsonObject() && jsonElement.getAsJsonObject().size() == 0;
    }

    private boolean readBoolean(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.BOOLEAN) {
            return jsonReader.nextBoolean();
        }
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER) {
            return Boolean.parseBoolean(jsonReader.nextString());
        }
        throw new JsonParseException("Token of type " + (Object)((Object)jsonToken) + " cannot be interpreted as a boolean");
    }

    private Object legacyHoverEventContents(HoverEvent.Action<?> action, Component component) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return component;
        }
        if (this.legacyHover != null) {
            try {
                if (action == HoverEvent.Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(component, this.decoder());
                }
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(component);
                }
            }
            catch (IOException iOException) {
                throw new JsonParseException(iOException);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder() {
        return string -> this.gson.fromJson((String)string, SerializerFactory.COMPONENT_TYPE);
    }

    private Codec.Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, SerializerFactory.COMPONENT_TYPE);
    }

    @Override
    public final void write(JsonWriter jsonWriter, Style style) {
        Key key;
        ClickEvent clickEvent;
        String string;
        Object object;
        jsonWriter.beginObject();
        for (TextDecoration textDecoration : DECORATIONS) {
            object = style.decoration(textDecoration);
            if (object == TextDecoration.State.NOT_SET) continue;
            String string2 = TextDecoration.NAMES.key(textDecoration);
            assert (string2 != null);
            jsonWriter.name(string2);
            jsonWriter.value(object == TextDecoration.State.TRUE);
        }
        @Nullable TextColor textColor = style.color();
        if (textColor != null) {
            jsonWriter.name(COLOR);
            this.gson.toJson((Object)textColor, SerializerFactory.COLOR_TYPE, jsonWriter);
        }
        if ((string = style.insertion()) != null) {
            jsonWriter.name(INSERTION);
            jsonWriter.value(string);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            jsonWriter.name(CLICK_EVENT);
            jsonWriter.beginObject();
            jsonWriter.name("action");
            this.gson.toJson((Object)clickEvent.action(), SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
            jsonWriter.name("value");
            jsonWriter.value(clickEvent.value());
            jsonWriter.endObject();
        }
        if ((object = style.hoverEvent()) != null) {
            jsonWriter.name(HOVER_EVENT);
            jsonWriter.beginObject();
            jsonWriter.name("action");
            @Nullable HoverEvent.Action<V> action = ((HoverEvent)object).action();
            this.gson.toJson(action, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
            jsonWriter.name(HOVER_EVENT_CONTENTS);
            if (action == HoverEvent.Action.SHOW_ITEM) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.SHOW_ITEM_TYPE, jsonWriter);
            } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.SHOW_ENTITY_TYPE, jsonWriter);
            } else if (action == HoverEvent.Action.SHOW_TEXT) {
                this.gson.toJson(((HoverEvent)object).value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
            } else {
                throw new JsonParseException("Don't know how to serialize " + ((HoverEvent)object).value());
            }
            if (this.emitLegacyHover) {
                jsonWriter.name("value");
                this.serializeLegacyHoverEvent((HoverEvent<?>)object, jsonWriter);
            }
            jsonWriter.endObject();
        }
        if ((key = style.font()) != null) {
            jsonWriter.name(FONT);
            this.gson.toJson((Object)key, SerializerFactory.KEY_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter jsonWriter) {
        Component component;
        block7: {
            if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
                this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                return;
            }
            if (this.legacyHover == null) {
                jsonWriter.nullValue();
                return;
            }
            component = null;
            try {
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                    component = this.legacyHover.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder());
                    break block7;
                }
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                    component = this.legacyHover.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
                }
            }
            catch (IOException iOException) {
                throw new JsonSyntaxException(iOException);
            }
        }
        if (component != null) {
            this.gson.toJson((Object)component, SerializerFactory.COMPONENT_TYPE, jsonWriter);
            return;
        }
        jsonWriter.nullValue();
    }

    static {
        EnumSet<TextDecoration> enumSet = EnumSet.allOf(TextDecoration.class);
        TextDecoration[] textDecorationArray = DECORATIONS;
        int n2 = DECORATIONS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextDecoration textDecoration = textDecorationArray[i2];
            enumSet.remove(textDecoration);
        }
        if (!enumSet.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + enumSet);
        }
    }
}

