/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextReplacementConfig;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.ClickEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.flattener.ComponentFlattener;
import me.extremall.advancedkits.libs.kyori.adventure.text.flattener.FlattenerListener;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.NamedTextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.Style;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextDecoration;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextFormat;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.legacy.LegacyFormat;
import me.extremall.advancedkits.libs.kyori.adventure.util.Services;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LegacyComponentSerializerImpl
implements LegacyComponentSerializer {
    static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-.]*:");
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final char LEGACY_BUNGEE_HEX_CHAR = 'x';
    private static final List<TextFormat> FORMATS;
    private static final String LEGACY_CHARS;
    private static final Optional<LegacyComponentSerializer.Provider> SERVICE;
    static final Consumer<LegacyComponentSerializer.Builder> BUILDER;
    private final char character;
    private final char hexCharacter;
    @Nullable
    private final TextReplacementConfig urlReplacementConfig;
    private final boolean hexColours;
    private final boolean useTerriblyStupidHexFormat;
    private final ComponentFlattener flattener;

    LegacyComponentSerializerImpl(char c2, char c3, @Nullable TextReplacementConfig textReplacementConfig, boolean bl2, boolean bl3, ComponentFlattener componentFlattener) {
        this.character = c2;
        this.hexCharacter = c3;
        this.urlReplacementConfig = textReplacementConfig;
        this.hexColours = bl2;
        this.useTerriblyStupidHexFormat = bl3;
        this.flattener = componentFlattener;
    }

    @Nullable
    private FormatCodeType determineFormatType(char c2, String string, int n2) {
        if (n2 >= 14) {
            int n3 = n2 - 14;
            int n4 = n2 - 13;
            if (string.charAt(n3) == this.character && string.charAt(n4) == 'x') {
                return FormatCodeType.BUNGEECORD_UNUSUAL_HEX;
            }
        }
        if (c2 == this.hexCharacter && string.length() - n2 >= 6) {
            return FormatCodeType.KYORI_HEX;
        }
        if (LEGACY_CHARS.indexOf(c2) != -1) {
            return FormatCodeType.MOJANG_LEGACY;
        }
        return null;
    }

    @Nullable
    static LegacyFormat legacyFormat(char c2) {
        int n2 = LEGACY_CHARS.indexOf(c2);
        c2 = (char)n2;
        if (n2 != -1) {
            TextFormat textFormat = FORMATS.get(c2);
            if (textFormat instanceof NamedTextColor) {
                return new LegacyFormat((NamedTextColor)textFormat);
            }
            if (textFormat instanceof TextDecoration) {
                return new LegacyFormat((TextDecoration)textFormat);
            }
            if (textFormat instanceof Reset) {
                return LegacyFormat.RESET;
            }
        }
        return null;
    }

    @Nullable
    private DecodedFormat decodeTextFormat(char c2, String string, int n2) {
        FormatCodeType formatCodeType = this.determineFormatType(c2, string, n2);
        if (formatCodeType == null) {
            return null;
        }
        if (formatCodeType == FormatCodeType.KYORI_HEX) {
            int n3 = n2;
            @Nullable TextColor textColor = LegacyComponentSerializerImpl.tryParseHexColor(string.substring(n3, n3 + 6));
            if (textColor != null) {
                return new DecodedFormat(formatCodeType, textColor);
            }
        } else {
            if (formatCodeType == FormatCodeType.MOJANG_LEGACY) {
                return new DecodedFormat(formatCodeType, FORMATS.get(LEGACY_CHARS.indexOf(c2)));
            }
            if (formatCodeType == FormatCodeType.BUNGEECORD_UNUSUAL_HEX) {
                StringBuilder stringBuilder = new StringBuilder(6);
                for (int i2 = n2 - 1; i2 >= n2 - 11; i2 -= 2) {
                    stringBuilder.append(string.charAt(i2));
                }
                @Nullable TextColor textColor = LegacyComponentSerializerImpl.tryParseHexColor(stringBuilder.reverse().toString());
                if (textColor != null) {
                    return new DecodedFormat(formatCodeType, textColor);
                }
            }
        }
        return null;
    }

    @Nullable
    private static TextColor tryParseHexColor(String string) {
        try {
            int n2 = Integer.parseInt(string, 16);
            return TextColor.color(n2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean isHexTextColor(TextFormat textFormat) {
        return textFormat instanceof TextColor && !(textFormat instanceof NamedTextColor);
    }

    private String toLegacyCode(TextFormat object) {
        if (LegacyComponentSerializerImpl.isHexTextColor((TextFormat)object)) {
            object = (TextColor)object;
            if (this.hexColours) {
                object = String.format("%06x", object.value());
                if (this.useTerriblyStupidHexFormat) {
                    StringBuilder stringBuilder = new StringBuilder("x");
                    int n2 = ((String)object).length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        stringBuilder.append(this.character).append(((String)object).charAt(i2));
                    }
                    return stringBuilder.toString();
                }
                return this.hexCharacter + (String)object;
            }
            object = NamedTextColor.nearestTo((TextColor)object);
        }
        int n3 = FORMATS.indexOf(object);
        return Character.toString(LEGACY_CHARS.charAt(n3));
    }

    private TextComponent extractUrl(TextComponent component) {
        if (this.urlReplacementConfig == null) {
            return component;
        }
        if ((component = component.replaceText(this.urlReplacementConfig)) instanceof TextComponent) {
            return component;
        }
        return (TextComponent)((TextComponent.Builder)Component.text().append(component)).build();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public final TextComponent deserialize(@NotNull String var1_1) {
        var2_2 = var1_1.lastIndexOf(this.character, var1_1.length() - 2);
        if (var2_2 == -1) {
            return this.extractUrl(Component.text(var1_1));
        }
        var3_3 = new ArrayList<TextComponent>();
        var4_4 = null;
        var5_5 = false;
        var6_6 = var1_1.length();
        do {
            block10: {
                block9: {
                    if ((var7_7 = this.decodeTextFormat(var1_1.charAt(var2_2 + 1), var1_1, var2_2 + 2)) == null) continue;
                    var8_8 = var2_2 + (var7_7.encodedFormat == FormatCodeType.KYORI_HEX ? 8 : 2);
                    if (var8_8 == var6_6) break block9;
                    if (var4_4 == null) ** GOTO lbl19
                    if (!var5_5) {
                        var4_4 = (TextComponent.Builder)Component.text().append((Component)var4_4.build());
                    } else {
                        var3_3.add((TextComponent)var4_4.build());
                        var5_5 = false;
lbl19:
                        // 2 sources

                        var4_4 = Component.text();
                    }
                    var4_4.content(var1_1.substring(var8_8, var6_6));
                    break block10;
                }
                if (var4_4 == null) {
                    var4_4 = Component.text();
                }
            }
            if (!var5_5) {
                var5_5 = LegacyComponentSerializerImpl.applyFormat(var4_4, var7_7.format);
            }
            if (var7_7.encodedFormat == FormatCodeType.BUNGEECORD_UNUSUAL_HEX) {
                var2_2 -= 12;
            }
            var6_6 = var2_2;
        } while ((var2_2 = var1_1.lastIndexOf(this.character, var2_2 - 1)) != -1);
        if (var4_4 != null) {
            var3_3.add((TextComponent)var4_4.build());
        }
        v0 = var7_7 = var6_6 > 0 ? var1_1.substring(0, var6_6) : "";
        if (var3_3.size() == 1 && var7_7.isEmpty()) {
            return this.extractUrl((TextComponent)var3_3.get(0));
        }
        Collections.reverse(var3_3);
        return this.extractUrl((TextComponent)((TextComponent.Builder)Component.text().content((String)var7_7).append(var3_3)).build());
    }

    @Override
    @NotNull
    public final String serialize(@NotNull Component component) {
        Cereal cereal = new Cereal();
        this.flattener.flatten(component, cereal);
        return cereal.toString();
    }

    private static boolean applyFormat(@NotNull TextComponent.Builder builder, @NotNull TextFormat textFormat) {
        if (textFormat instanceof TextColor) {
            builder.colorIfAbsent((TextColor)textFormat);
            return true;
        }
        if (textFormat instanceof TextDecoration) {
            builder.decoration((TextDecoration)textFormat, TextDecoration.State.TRUE);
            return false;
        }
        if (textFormat instanceof Reset) {
            return true;
        }
        throw new IllegalArgumentException(String.format("unknown format '%s'", textFormat.getClass()));
    }

    @Override
    @NotNull
    public final LegacyComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>(22);
        linkedHashMap.put(NamedTextColor.BLACK, "0");
        linkedHashMap.put(NamedTextColor.DARK_BLUE, "1");
        linkedHashMap.put(NamedTextColor.DARK_GREEN, "2");
        linkedHashMap.put(NamedTextColor.DARK_AQUA, "3");
        linkedHashMap.put(NamedTextColor.DARK_RED, "4");
        linkedHashMap.put(NamedTextColor.DARK_PURPLE, "5");
        linkedHashMap.put(NamedTextColor.GOLD, "6");
        linkedHashMap.put(NamedTextColor.GRAY, "7");
        linkedHashMap.put(NamedTextColor.DARK_GRAY, "8");
        linkedHashMap.put(NamedTextColor.BLUE, "9");
        linkedHashMap.put(NamedTextColor.GREEN, "a");
        linkedHashMap.put(NamedTextColor.AQUA, "b");
        linkedHashMap.put(NamedTextColor.RED, "c");
        linkedHashMap.put(NamedTextColor.LIGHT_PURPLE, "d");
        linkedHashMap.put(NamedTextColor.YELLOW, "e");
        linkedHashMap.put(NamedTextColor.WHITE, "f");
        linkedHashMap.put(TextDecoration.OBFUSCATED, "k");
        linkedHashMap.put(TextDecoration.BOLD, "l");
        linkedHashMap.put(TextDecoration.STRIKETHROUGH, "m");
        linkedHashMap.put(TextDecoration.UNDERLINED, "n");
        linkedHashMap.put(TextDecoration.ITALIC, "o");
        linkedHashMap.put(Reset.INSTANCE, "r");
        FORMATS = Collections.unmodifiableList(new ArrayList(linkedHashMap.keySet()));
        LEGACY_CHARS = String.join((CharSequence)"", linkedHashMap.values());
        if (FORMATS.size() != LEGACY_CHARS.length()) {
            throw new IllegalStateException("FORMATS length differs from LEGACY_CHARS length");
        }
        SERVICE = Services.service(LegacyComponentSerializer.Provider.class);
        BUILDER = SERVICE.map(LegacyComponentSerializer.Provider::legacy).orElseGet(() -> builder -> {});
    }

    static final class DecodedFormat {
        final FormatCodeType encodedFormat;
        final TextFormat format;

        private DecodedFormat(FormatCodeType formatCodeType, TextFormat textFormat) {
            if (textFormat == null) {
                throw new IllegalStateException("No format found");
            }
            this.encodedFormat = formatCodeType;
            this.format = textFormat;
        }
    }

    static enum FormatCodeType {
        MOJANG_LEGACY,
        KYORI_HEX,
        BUNGEECORD_UNUSUAL_HEX;

    }

    static final class BuilderImpl
    implements LegacyComponentSerializer.Builder {
        private char character = (char)167;
        private char hexCharacter = (char)35;
        private TextReplacementConfig urlReplacementConfig = null;
        private boolean hexColours = false;
        private boolean useTerriblyStupidHexFormat = false;
        private ComponentFlattener flattener = ComponentFlattener.basic();

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(@NotNull LegacyComponentSerializerImpl legacyComponentSerializerImpl) {
            this();
            this.character = legacyComponentSerializerImpl.character;
            this.hexCharacter = legacyComponentSerializerImpl.hexCharacter;
            this.urlReplacementConfig = legacyComponentSerializerImpl.urlReplacementConfig;
            this.hexColours = legacyComponentSerializerImpl.hexColours;
            this.useTerriblyStupidHexFormat = legacyComponentSerializerImpl.useTerriblyStupidHexFormat;
            this.flattener = legacyComponentSerializerImpl.flattener;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder character(char c2) {
            this.character = c2;
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder hexCharacter(char c2) {
            this.hexCharacter = c2;
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder extractUrls() {
            return this.extractUrls(DEFAULT_URL_PATTERN, null);
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder extractUrls(@NotNull Pattern pattern) {
            return this.extractUrls(pattern, null);
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder extractUrls(@Nullable Style style) {
            return this.extractUrls(DEFAULT_URL_PATTERN, style);
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder extractUrls(@NotNull Pattern pattern, @Nullable Style style) {
            Objects.requireNonNull(pattern, "pattern");
            this.urlReplacementConfig = (TextReplacementConfig)TextReplacementConfig.builder().match(pattern).replacement(builder -> {
                String string = builder.content();
                if (!URL_SCHEME_PATTERN.matcher(string).find()) {
                    string = "http://" + string;
                }
                return (style == null ? builder : (TextComponent.Builder)builder.style(style)).clickEvent(ClickEvent.openUrl(string));
            }).build();
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder hexColors() {
            this.hexColours = true;
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder useUnusualXRepeatedCharacterHexFormat() {
            this.useTerriblyStupidHexFormat = true;
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer.Builder flattener(@NotNull ComponentFlattener componentFlattener) {
            this.flattener = Objects.requireNonNull(componentFlattener, "flattener");
            return this;
        }

        @Override
        @NotNull
        public final LegacyComponentSerializer build() {
            return new LegacyComponentSerializerImpl(this.character, this.hexCharacter, this.urlReplacementConfig, this.hexColours, this.useTerriblyStupidHexFormat, this.flattener);
        }
    }

    final class Cereal
    implements FlattenerListener {
        private final StringBuilder sb = new StringBuilder();
        private final StyleState style = new StyleState();
        @Nullable
        private TextFormat lastWritten;
        private StyleState[] styles = new StyleState[8];
        private int head = -1;

        private Cereal() {
        }

        @Override
        public final void pushStyle(@NotNull Style style) {
            StyleState styleState;
            int n2 = ++this.head;
            if (this.head >= this.styles.length) {
                this.styles = Arrays.copyOf(this.styles, this.styles.length << 1);
            }
            if ((styleState = this.styles[n2]) == null) {
                this.styles[n2] = styleState = new StyleState();
            }
            if (n2 > 0) {
                styleState.set(this.styles[n2 - 1]);
            } else {
                styleState.clear();
            }
            styleState.apply(style);
        }

        @Override
        public final void component(@NotNull String string) {
            if (!string.isEmpty()) {
                if (this.head < 0) {
                    throw new IllegalStateException("No style has been pushed!");
                }
                this.styles[this.head].applyFormat();
                this.sb.append(string);
            }
        }

        @Override
        public final void popStyle(@NotNull Style style) {
            if (this.head-- < 0) {
                throw new IllegalStateException("Tried to pop beyond what was pushed!");
            }
        }

        final void append(@NotNull TextFormat textFormat) {
            if (this.lastWritten != textFormat) {
                this.sb.append(LegacyComponentSerializerImpl.this.character).append(LegacyComponentSerializerImpl.this.toLegacyCode(textFormat));
            }
            this.lastWritten = textFormat;
        }

        public final String toString() {
            return this.sb.toString();
        }

        final class StyleState {
            @Nullable
            private TextColor color;
            private final Set<TextDecoration> decorations = EnumSet.noneOf(TextDecoration.class);
            private boolean needsReset;

            StyleState() {
            }

            final void set(@NotNull StyleState styleState) {
                this.color = styleState.color;
                this.decorations.clear();
                this.decorations.addAll(styleState.decorations);
            }

            public final void clear() {
                this.color = null;
                this.decorations.clear();
            }

            final void apply(@NotNull Style style) {
                TextColor textColor = style.color();
                if (textColor != null) {
                    this.color = textColor;
                }
                int n2 = DECORATIONS.length;
                block4: for (int i2 = 0; i2 < n2; ++i2) {
                    TextDecoration textDecoration = DECORATIONS[i2];
                    switch (style.decoration(textDecoration)) {
                        case TRUE: {
                            this.decorations.add(textDecoration);
                            continue block4;
                        }
                        case FALSE: {
                            if (!this.decorations.remove(textDecoration)) continue block4;
                            this.needsReset = true;
                        }
                    }
                }
            }

            final void applyFormat() {
                boolean bl2;
                boolean bl3 = bl2 = this.color != ((Cereal)Cereal.this).style.color;
                if (this.needsReset) {
                    if (!bl2) {
                        Cereal.this.append(Reset.INSTANCE);
                    }
                    this.needsReset = false;
                }
                if (bl2 || Cereal.this.lastWritten == Reset.INSTANCE) {
                    this.applyFullFormat();
                    return;
                }
                if (!this.decorations.containsAll(((Cereal)Cereal.this).style.decorations)) {
                    this.applyFullFormat();
                    return;
                }
                for (TextDecoration textDecoration : this.decorations) {
                    if (!((Cereal)Cereal.this).style.decorations.add(textDecoration)) continue;
                    Cereal.this.append(textDecoration);
                }
            }

            private void applyFullFormat() {
                if (this.color != null) {
                    Cereal.this.append(this.color);
                } else {
                    Cereal.this.append(Reset.INSTANCE);
                }
                ((Cereal)Cereal.this).style.color = this.color;
                for (TextDecoration textDecoration : this.decorations) {
                    Cereal.this.append(textDecoration);
                }
                ((Cereal)Cereal.this).style.decorations.clear();
                ((Cereal)Cereal.this).style.decorations.addAll(this.decorations);
            }
        }
    }

    static enum Reset implements TextFormat
    {
        INSTANCE;

    }

    static final class Instances {
        static final LegacyComponentSerializer SECTION = LegacyComponentSerializerImpl.access$000().map(LegacyComponentSerializer.Provider::legacySection).orElseGet(() -> new LegacyComponentSerializerImpl('\u00a7', '#', null, false, false, ComponentFlattener.basic()));
        static final LegacyComponentSerializer AMPERSAND = LegacyComponentSerializerImpl.access$000().map(LegacyComponentSerializer.Provider::legacyAmpersand).orElseGet(() -> new LegacyComponentSerializerImpl('&', '#', null, false, false, ComponentFlattener.basic()));

        Instances() {
        }
    }
}

