/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.relocation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;

public class Relocation {
    private final String pattern;
    private final String relocatedPattern;
    private final Collection<String> includes;
    private final Collection<String> excludes;

    public Relocation(String string, String string2, Collection<String> collection, Collection<String> collection2) {
        this.pattern = Objects.requireNonNull(string, "pattern").replace("{}", ".");
        this.relocatedPattern = Objects.requireNonNull(string2, "relocatedPattern").replace("{}", ".");
        this.includes = collection != null ? Collections.unmodifiableList(new LinkedList<String>(collection)) : Collections.emptyList();
        this.excludes = collection2 != null ? Collections.unmodifiableList(new LinkedList<String>(collection2)) : Collections.emptyList();
    }

    public Relocation(String string, String string2) {
        this(string, string2, null, null);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRelocatedPattern() {
        return this.relocatedPattern;
    }

    public Collection<String> getIncludes() {
        return this.includes;
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pattern;
        private String relocatedPattern;
        private final Collection<String> includes = new LinkedList<String>();
        private final Collection<String> excludes = new LinkedList<String>();

        public Builder pattern(String string) {
            this.pattern = Objects.requireNonNull(string, "pattern");
            return this;
        }

        public Builder relocatedPattern(String string) {
            this.relocatedPattern = Objects.requireNonNull(string, "relocatedPattern");
            return this;
        }

        public Builder include(String string) {
            this.includes.add(Objects.requireNonNull(string, "include"));
            return this;
        }

        public Builder exclude(String string) {
            this.excludes.add(Objects.requireNonNull(string, "exclude"));
            return this;
        }

        public Relocation build() {
            return new Relocation(this.pattern, this.relocatedPattern, this.includes, this.excludes);
        }
    }
}

