/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby.relocation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.LibraryManager;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.relocation.Relocation;

public class RelocationHelper {
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final Constructor<?> relocationConstructor;

    public RelocationHelper(LibraryManager object) {
        Objects.requireNonNull(object, "libraryManager");
        Object object2 = new IsolatedClassLoader(new URL[0]);
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("org.ow2.asm").artifactId("asm-commons").version("9.2").checksum("vkzlMTiiOLtSLNeBz5Hzulzi9sqT7GLUahYqEnIl4KY=").repository("https://repo1.maven.org/maven2/").build()));
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("org.ow2.asm").artifactId("asm").version("9.2").checksum("udT+TXGTjfOIOfDspCqqpkz4sxPWeNoDbwyzyhmbR/U=").repository("https://repo1.maven.org/maven2/").build()));
        ((IsolatedClassLoader)object2).addPath(((LibraryManager)object).downloadLibrary(Library.builder().groupId("me.lucko").artifactId("jar-relocator").version("1.5").checksum("0D6eM99gKpEYFNDydgnto3Df0ygZGdRVqy5ahtj0oIs=").repository("https://repo1.maven.org/maven2/").build()));
        try {
            object = ((ClassLoader)object2).loadClass("me.lucko.jarrelocator.JarRelocator");
            object2 = ((ClassLoader)object2).loadClass("me.lucko.jarrelocator.Relocation");
            this.jarRelocatorConstructor = ((Class)object).getConstructor(File.class, File.class, Collection.class);
            this.jarRelocatorRunMethod = ((Class)object).getMethod("run", new Class[0]);
            this.relocationConstructor = ((Class)object2).getConstructor(String.class, String.class, Collection.class, Collection.class);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void relocate(Path path, Path path2, Collection<Relocation> object) {
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(path2, "out");
        Objects.requireNonNull(object, "relocations");
        try {
            LinkedList linkedList = new LinkedList();
            object = object.iterator();
            while (object.hasNext()) {
                Relocation relocation = (Relocation)object.next();
                linkedList.add(this.relocationConstructor.newInstance(relocation.getPattern(), relocation.getRelocatedPattern(), relocation.getIncludes(), relocation.getExcludes()));
            }
            this.jarRelocatorRunMethod.invoke(this.jarRelocatorConstructor.newInstance(path.toFile(), path2.toFile(), linkedList), new Object[0]);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

