/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.extremall.advancedkits.libs.nbtapi.NBTType;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.iface.NBTHandler;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteNBT;
import me.extremall.advancedkits.libs.nbtapi.wrapper.Casing;
import me.extremall.advancedkits.libs.nbtapi.wrapper.DefaultMethodInvoker;
import me.extremall.advancedkits.libs.nbtapi.wrapper.NBTProxy;
import me.extremall.advancedkits.libs.nbtapi.wrapper.NBTTarget;
import me.extremall.advancedkits.libs.nbtapi.wrapper.ProxiedList;
import me.extremall.advancedkits.libs.nbtapi.wrapper.ProxyList;

public class ProxyBuilder<T extends NBTProxy>
implements InvocationHandler {
    private static final Map<Method, Function<Arguments, Object>> METHOD_CACHE = new ConcurrentHashMap<Method, Function<Arguments, Object>>();
    private final Class<T> target;
    private final ReadWriteNBT nbt;
    private boolean readOnly;

    public ProxyBuilder(ReadWriteNBT readWriteNBT, Class<T> clazz) {
        if (!clazz.isInterface()) {
            throw new NbtApiException("A proxy can only be built from an interface! Check the wiki for examples.");
        }
        this.target = clazz;
        this.nbt = readWriteNBT;
    }

    public ProxyBuilder<T> readOnly() {
        this.readOnly = true;
        return this;
    }

    public T build() {
        NBTProxy nBTProxy = (NBTProxy)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.target}, (InvocationHandler)this);
        nBTProxy.init();
        return (T)nBTProxy;
    }

    @Override
    public Object invoke(Object object, Method method2, Object[] objectArray) {
        METHOD_CACHE.computeIfAbsent(method2, method -> ProxyBuilder.createFunction((NBTProxy)object, method));
        return METHOD_CACHE.get(method2).apply(new Arguments(this.target, (NBTProxy)object, this.readOnly, this.nbt, objectArray));
    }

    private static Function<Arguments, Object> createFunction(NBTProxy nBTProxy, Method nBTHandler) {
        if ("toString".equals(((Method)((Object)nBTHandler)).getName()) && ((Method)((Object)nBTHandler)).getParameterCount() == 0 && ((Method)((Object)nBTHandler)).getReturnType() == String.class) {
            return arguments -> arguments.nbt.toString();
        }
        if (((Method)((Object)nBTHandler)).isDefault()) {
            return arg_0 -> ProxyBuilder.lambda$createFunction$2((Method)((Object)nBTHandler), arg_0);
        }
        Object object = ProxyBuilder.getAction((Method)((Object)nBTHandler));
        if (object == NBTTarget.Type.SET) {
            object = ProxyBuilder.getNBTName(nBTProxy.getCasing(), (Method)((Object)nBTHandler));
            return arg_0 -> ProxyBuilder.lambda$createFunction$3((String)object, arg_0);
        }
        if (object == NBTTarget.Type.GET) {
            object = ((Method)((Object)nBTHandler)).getReturnType();
            String string = ProxyBuilder.getNBTName(nBTProxy.getCasing(), (Method)((Object)nBTHandler));
            if (((Class)object).isInterface() && NBTProxy.class.isAssignableFrom((Class<?>)object)) {
                return arg_0 -> ProxyBuilder.lambda$createFunction$4(string, (Class)object, arg_0);
            }
            if (object == ProxyList.class && (nBTHandler = (Class)((ParameterizedType)((Method)((Object)nBTHandler)).getGenericReturnType()).getActualTypeArguments()[0]) != null && ((Class)((Object)nBTHandler)).isInterface() && NBTProxy.class.isAssignableFrom((Class<?>)((Object)nBTHandler))) {
                return arg_0 -> ProxyBuilder.lambda$createFunction$5(string, (Class)((Object)nBTHandler), arg_0);
            }
            nBTHandler = nBTProxy.getHandler(object);
            if (nBTHandler != null) {
                return arguments -> nBTHandler.get(arguments.nbt, string);
            }
            return arg_0 -> ProxyBuilder.lambda$createFunction$7(string, (Class)object, arg_0);
        }
        if (object == NBTTarget.Type.HAS) {
            object = ProxyBuilder.getNBTName(nBTProxy.getCasing(), (Method)((Object)nBTHandler));
            return arg_0 -> ProxyBuilder.lambda$createFunction$8((String)object, arg_0);
        }
        throw new IllegalArgumentException("The method '" + ((Method)((Object)nBTHandler)).getName() + "' in '" + ((Method)((Object)nBTHandler)).getDeclaringClass().getName() + "' can not be handled by the NBT-API. Please check the Wiki for examples!");
    }

    private static NBTTarget.Type getAction(Method method) {
        NBTTarget nBTTarget = method.getAnnotation(NBTTarget.class);
        if (nBTTarget != null) {
            if (nBTTarget.type() == NBTTarget.Type.HAS && method.getParameterCount() == 0 && method.getReturnType() == Boolean.TYPE) {
                return NBTTarget.Type.HAS;
            }
            if (nBTTarget.type() == NBTTarget.Type.GET && method.getParameterCount() == 0) {
                return NBTTarget.Type.GET;
            }
            if (nBTTarget.type() == NBTTarget.Type.SET && method.getParameterCount() == 1) {
                return NBTTarget.Type.SET;
            }
        }
        if (method.getName().startsWith("set") && method.getParameterCount() == 1) {
            return NBTTarget.Type.SET;
        }
        if (method.getName().startsWith("get") && method.getParameterCount() == 0) {
            return NBTTarget.Type.GET;
        }
        if (method.getName().startsWith("has") && method.getParameterCount() == 0 && method.getReturnType() == Boolean.TYPE) {
            return NBTTarget.Type.HAS;
        }
        return null;
    }

    private static String getNBTName(Casing casing, Method method) {
        NBTTarget nBTTarget = method.getAnnotation(NBTTarget.class);
        if (nBTTarget != null) {
            return nBTTarget.value();
        }
        return casing.convertString(method.getName().substring(3));
    }

    private static Object setNBT(ReadWriteNBT readWriteNBT, NBTProxy object, String string, Object object2) {
        if (object2 == null) {
            readWriteNBT.removeKey(string);
        } else if (object2 instanceof Boolean) {
            readWriteNBT.setBoolean(string, (Boolean)object2);
        } else if (object2 instanceof Byte) {
            readWriteNBT.setByte(string, (Byte)object2);
        } else if (object2 instanceof Short) {
            readWriteNBT.setShort(string, (Short)object2);
        } else if (object2 instanceof Integer) {
            readWriteNBT.setInteger(string, (Integer)object2);
        } else if (object2 instanceof Long) {
            readWriteNBT.setLong(string, (Long)object2);
        } else if (object2 instanceof Float) {
            readWriteNBT.setFloat(string, (Float)object2);
        } else if (object2 instanceof Double) {
            readWriteNBT.setDouble(string, (Double)object2);
        } else if (object2 instanceof byte[]) {
            readWriteNBT.setByteArray(string, (byte[])object2);
        } else if (object2 instanceof int[]) {
            readWriteNBT.setIntArray(string, (int[])object2);
        } else if (object2 instanceof long[]) {
            readWriteNBT.setLongArray(string, (long[])object2);
        } else if (object2 instanceof String) {
            readWriteNBT.setString(string, (String)object2);
        } else if (object2 instanceof UUID) {
            readWriteNBT.setUUID(string, (UUID)object2);
        } else if (object2.getClass().isEnum()) {
            readWriteNBT.setEnum(string, (Enum)object2);
        } else {
            NBTHandler<?> nBTHandler2 = object.getHandler(object2.getClass());
            if (nBTHandler2 != null) {
                nBTHandler2.set(readWriteNBT, string, object2);
            } else {
                for (NBTHandler<Object> nBTHandler : object.getHandlers()) {
                    if (!nBTHandler.fuzzyMatch(object2)) continue;
                    nBTHandler.set(readWriteNBT, string, object2);
                    return null;
                }
                throw new IllegalArgumentException("Tried setting an object of type '" + object2.getClass().getName() + "'. This is not a supported NBT value. Please check the Wiki for examples!");
            }
        }
        return null;
    }

    private static /* synthetic */ Object lambda$createFunction$8(String string, Arguments arguments) {
        return arguments.nbt.hasTag(string);
    }

    private static /* synthetic */ Object lambda$createFunction$7(String string, Class clazz, Arguments arguments) {
        return arguments.nbt.getOrNull(string, clazz);
    }

    private static /* synthetic */ Object lambda$createFunction$5(String string, Class clazz, Arguments arguments) {
        return new ProxiedList(arguments.nbt.getCompoundList(string), clazz);
    }

    private static /* synthetic */ Object lambda$createFunction$4(String string, Class clazz, Arguments arguments) {
        if (arguments.nbt.hasTag(string) && arguments.nbt.getType(string) != NBTType.NBTTagCompound) {
            throw new NbtApiException("Tried getting a '" + clazz + "' proxy from the field '" + string + "', but it's not a TagCompound!");
        }
        return new ProxyBuilder(arguments.nbt.getOrCreateCompound(string), clazz).build();
    }

    private static /* synthetic */ Object lambda$createFunction$3(String string, Arguments arguments) {
        if (arguments.readOnly) {
            throw new NbtApiException("Tried calling a set method on a read only object.");
        }
        return ProxyBuilder.setNBT(arguments.nbt, arguments.proxy, string, arguments.args[0]);
    }

    private static /* synthetic */ Object lambda$createFunction$2(Method method, Arguments arguments) {
        return DefaultMethodInvoker.invokeDefault(arguments.target, arguments.proxy, method, arguments.args);
    }

    static class Arguments {
        Class<?> target;
        NBTProxy proxy;
        ReadWriteNBT nbt;
        Object[] args;
        boolean readOnly;

        public Arguments(Class<?> clazz, NBTProxy nBTProxy, boolean bl2, ReadWriteNBT readWriteNBT, Object[] objectArray) {
            this.target = clazz;
            this.proxy = nBTProxy;
            this.nbt = readWriteNBT;
            this.args = objectArray;
            this.readOnly = bl2;
        }
    }
}

