/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.object.Purchase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PersistenceManager {
    private final AdvancedLottery plugin;
    private final File temp;

    public PersistenceManager(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.temp = new File(plugin.getDataFolder() + "/data", "lottery.tmp");
    }

    public boolean loadPreviousLotterySnapshot() {
        if (!this.temp.exists()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.temp));){
            String s;
            long timeLeft = Long.parseLong(reader.readLine());
            this.plugin.getLotteryTimer().setDuration(timeLeft);
            while ((s = reader.readLine()) != null) {
                String[] tokens = s.split("#");
                UUID uuid = UUID.fromString(tokens[0]);
                int tickets = Integer.parseInt(tokens[1]);
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                Purchase purchase = new Purchase(player, tickets, this.plugin);
                purchase.executePurchase(false, false);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to read previous lottery data!", e);
            return false;
        }
        if (!this.temp.delete()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to delete temp snapshot!");
            return false;
        }
        return true;
    }

    public void saveCurrentLotterySnapshot() {
        this.temp.getParentFile().mkdirs();
        try {
            this.temp.createNewFile();
            FileWriter writer = new FileWriter(this.temp, false);
            writer.write(this.plugin.getLotteryTimer().timeLeft() + "\n");
            for (Map.Entry<UUID, Integer> entry : LotteryTicket.getInstance(this.plugin).getWhoBought().entrySet()) {
                writer.write(entry.getKey().toString() + "#" + entry.getValue() + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create tmp file!", e);
        }
    }
}

