/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.gui;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.ItemGrabber;
import com.gmail.ianlim224.advancedlottery.gui.HeadLocation;
import com.gmail.ianlim224.advancedlottery.gui.LotteryHolder;
import com.gmail.ianlim224.advancedlottery.items.MenuItems;
import com.gmail.ianlim224.advancedlottery.utils.ItemBuilder;
import com.gmail.ianlim224.utils.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class LotteryGUI {
    private static final int[] PANE_SLOTS = new int[]{45, 46, 47, 51, 52, 53};
    private static LotteryGUI instance = null;
    private ArrayList<Inventory> menuInventory = null;
    private HashMap<Player, Integer> playerPage;
    private HashMap<UUID, HeadLocation> heads;
    private ItemGrabber grabber;

    private LotteryGUI() {
    }

    public static LotteryGUI getInstance() {
        if (instance == null) {
            instance = new LotteryGUI();
        }
        return instance;
    }

    public void load(AdvancedLottery plugin) {
        this.menuInventory = new ArrayList();
        this.playerPage = new HashMap();
        this.grabber = ItemGrabber.getInstance(plugin);
        this.heads = new HashMap();
        this.addNewPage();
        this.loadMenu();
    }

    public void reset(AdvancedLottery plugin) {
        this.menuInventory = null;
        this.playerPage = null;
        this.grabber = null;
        this.heads = null;
        this.load(plugin);
    }

    public Inventory createNewInventory() {
        return Bukkit.createInventory((InventoryHolder)new LotteryHolder(), (int)54, (String)AdvancedLottery.f(AdvancedLottery.getLotteryGrabber().getLotteryMenuName().replaceAll("%number%", Integer.toString(this.menuInventory.size() + 1))));
    }

    public void openFirstPage(Player paramPlayer) {
        paramPlayer.openInventory(this.menuInventory.get(0));
        this.playerPage.put(paramPlayer, 1);
    }

    public void openNextPage(Player paramPlayer) {
        if (this.menuInventory.size() - this.playerPage.get(paramPlayer) <= 0) {
            return;
        }
        paramPlayer.openInventory(this.menuInventory.get(this.playerPage.get(paramPlayer)));
        this.playerPage.put(paramPlayer, this.playerPage.get(paramPlayer) + 1);
    }

    public void openPreviousPage(Player paramPlayer) {
        if (this.playerPage.get(paramPlayer) - 1 < 0) {
            return;
        }
        paramPlayer.openInventory(this.menuInventory.get(this.playerPage.get(paramPlayer) - 1));
        this.playerPage.put(paramPlayer, this.playerPage.get(paramPlayer) - 1);
    }

    public void addPlayer(OfflinePlayer player) {
        int slotIndex;
        if (this.heads.containsKey(player.getUniqueId())) {
            HeadLocation location = this.heads.get(player.getUniqueId());
            this.menuInventory.get(location.getInventoryIndex()).setItem(location.getSlotIndex(), AdvancedLottery.getInstance().getSkullManager().getSkull(player));
            return;
        }
        if (this.getLastPage().firstEmpty() != -1) {
            slotIndex = this.getLastPage().firstEmpty();
            this.getLastPage().setItem(this.getLastPage().firstEmpty(), AdvancedLottery.getInstance().getSkullManager().getSkull(player));
        } else {
            this.addNewPage();
            slotIndex = this.getLastPage().firstEmpty();
            this.getLastPage().addItem(new ItemStack[]{AdvancedLottery.getInstance().getSkullManager().getSkull(player)});
        }
        this.heads.put(player.getUniqueId(), new HeadLocation(this.menuInventory.size() - 1, slotIndex));
    }

    private Inventory getLastPage() {
        return this.menuInventory.get(this.menuInventory.size() - 1);
    }

    public List<Inventory> getMenuInventory() {
        return this.menuInventory;
    }

    public void addNewPage() {
        this.menuInventory.add(this.createNewInventory());
        this.loadMenu();
    }

    public void loadMenu() {
        for (Inventory inv : this.menuInventory) {
            for (int i : PANE_SLOTS) {
                inv.setItem(i, new ItemBuilder(XMaterial.matchXMaterial(MenuItems.MENU_PANE_MATERIAL.getStringValue()).get().parseItem()).setName(" ").toItemStack());
            }
            inv.setItem(48, this.grabber.getPreviousArrow());
            inv.setItem(50, this.grabber.getNextArrow());
            inv.setItem(49, this.grabber.getBuyButton());
        }
    }
}

