/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.hooks;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEcon {
    private final AdvancedLottery plugin;
    private Economy econ;

    public VaultEcon(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.econ = null;
    }

    public boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public boolean payMoney(double amount, OfflinePlayer player) {
        EconomyResponse localEconomyResponse = this.econ.depositPlayer(player, amount);
        return localEconomyResponse.transactionSuccess();
    }

    public boolean takeMoney(double amount, OfflinePlayer player) {
        EconomyResponse localEconomyResponse = this.econ.withdrawPlayer(player, amount);
        return localEconomyResponse.transactionSuccess();
    }

    public double getBalance(OfflinePlayer player) {
        return this.econ.getBalance(player);
    }
}

