/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.mysql;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.mysql.PlayerData;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LotterySql {
    private static LotterySql instance;
    private final AdvancedLottery plugin;
    private final Map<UUID, PlayerData> cache;
    private HikariDataSource hikari;
    private boolean isEnabled;

    private LotterySql(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.cache = new HashMap<UUID, PlayerData>();
        this.isEnabled = plugin.getConfig().getBoolean("mysql.enabled");
    }

    public static LotterySql getInstance(AdvancedLottery plugin) {
        if (instance == null) {
            instance = new LotterySql(plugin);
        }
        return instance;
    }

    public void initDatabase() {
        new BukkitRunnable(){

            public void run() {
                PreparedStatement statement;
                Connection connection;
                if (!LotterySql.this.isEnabled) {
                    LotterySql.this.plugin.getLogger().log(Level.INFO, "You are not using mysql, mysql functions will be disabled");
                    return;
                }
                FileConfiguration c = LotterySql.this.plugin.getConfig();
                LotterySql.this.plugin.getLogger().log(Level.INFO, "Connecting to database!");
                LotterySql.this.hikari = new HikariDataSource();
                String ip = c.getString("mysql.ip");
                String port = c.getString("mysql.port");
                String dbName = c.getString("mysql.database-name");
                LotterySql.this.hikari.setJdbcUrl(String.format("jdbc:mysql://%s:%s/%s", ip, port, dbName));
                LotterySql.this.hikari.addDataSourceProperty("user", c.getString("mysql.username"));
                LotterySql.this.hikari.addDataSourceProperty("password", c.getString("mysql.password"));
                try {
                    connection = LotterySql.this.hikari.getConnection();
                    try {
                        statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS Lottery(uuid VARCHAR(36), wins INT, tickets INT, money DOUBLE, money_won DOUBLE)");
                        try {
                            statement.execute();
                            LotterySql.this.plugin.getLogger().log(Level.INFO, "Successfully connected!");
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to connect to database", e);
                    LotterySql.this.isEnabled = false;
                }
                try {
                    connection = LotterySql.this.hikari.getConnection();
                    try {
                        statement = connection.prepareStatement("ALTER TABLE Lottery ADD COLUMN money_won DOUBLE NOT NULL DEFAULT 0");
                        try {
                            statement.execute();
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1060) {
                        LotterySql.this.plugin.getLogger().log(Level.INFO, "New column money_won already exists");
                    }
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to connect to database", e);
                    LotterySql.this.isEnabled = false;
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void close() {
        this.hikari.close();
    }

    public void addPlayerIfNotExists(final Player player) {
        if (!this.isEnabled) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                PreparedStatement statement;
                Connection connection;
                try {
                    connection = LotterySql.this.hikari.getConnection();
                    try {
                        statement = connection.prepareStatement("SELECT * FROM Lottery WHERE uuid = ?");
                        try {
                            statement.setString(1, player.getUniqueId().toString());
                            ResultSet result = statement.executeQuery();
                            if (result.isBeforeFirst()) {
                                return;
                            }
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute find player task", e);
                }
                try {
                    connection = LotterySql.this.hikari.getConnection();
                    try {
                        statement = connection.prepareStatement("INSERT INTO Lottery(uuid, wins, tickets, money, money_won) values (?, ?, ?, ?, ?)");
                        try {
                            statement.setString(1, player.getUniqueId().toString());
                            for (int i = 2; i < 6; ++i) {
                                statement.setInt(i, 0);
                            }
                            statement.execute();
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute sql tasks", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void addWins(final OfflinePlayer player) {
        if (!this.isEnabled) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = LotterySql.this.hikari.getConnection();
                     PreparedStatement statement = connection.prepareStatement("UPDATE Lottery SET wins = wins + 1 WHERE uuid = ?");){
                    statement.setString(1, player.getUniqueId().toString());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute update wins task", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void addMoneyWon(final OfflinePlayer player, final double amount) {
        if (!this.isEnabled) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = LotterySql.this.hikari.getConnection();
                     PreparedStatement statement = connection.prepareStatement("UPDATE Lottery SET money_won = money_won + " + amount + " WHERE uuid = ?");){
                    statement.setString(1, player.getUniqueId().toString());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute update wins task", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void addTicketsBought(final OfflinePlayer player, final int amount) {
        if (!this.isEnabled) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = LotterySql.this.hikari.getConnection();
                     PreparedStatement statement = connection.prepareStatement("UPDATE Lottery SET tickets = tickets + ? WHERE uuid = ?");){
                    statement.setInt(1, amount);
                    statement.setString(2, player.getUniqueId().toString());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute update tickets task", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void addMoney(final OfflinePlayer player, final double amount) {
        if (!this.isEnabled) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = LotterySql.this.hikari.getConnection();
                     PreparedStatement statement = connection.prepareStatement("UPDATE Lottery SET money = money + ? WHERE uuid = ?");){
                    statement.setDouble(1, amount);
                    statement.setString(2, player.getUniqueId().toString());
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LotterySql.this.plugin.getLogger().log(Level.SEVERE, "failed to execute update money task", e);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public PlayerData getStats(UUID uuid) {
        if (!this.isEnabled) {
            return null;
        }
        if (this.cache.containsKey(uuid)) {
            return this.cache.get(uuid);
        }
        PlayerData data = null;
        try (Connection connection = this.hikari.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * from Lottery WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int wins = resultSet.getInt("wins");
                int tickets = resultSet.getInt("tickets");
                double money = resultSet.getDouble("money");
                double money_won = resultSet.getDouble("money_won");
                data = new PlayerData(wins, tickets, money, money_won, uuid);
                this.cache.put(uuid, data);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "failed to get stats", e);
        }
        return data;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public HikariDataSource getHikariCp() {
        return this.hikari;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

