/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.object;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.clickablechat.ClickableText;
import com.gmail.ianlim224.advancedlottery.gui.LotteryGUI;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.mysql.LotterySql;
import com.gmail.ianlim224.advancedlottery.object.LotteryPot;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.object.TicketTransaction;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Purchase {
    private final OfflinePlayer player;
    private final TicketTransaction ticket;
    private final AdvancedLottery plugin;

    public Purchase(OfflinePlayer player, int ticketAmount, AdvancedLottery plugin) {
        this.player = player;
        this.ticket = new TicketTransaction(ticketAmount, plugin);
        this.plugin = plugin;
    }

    public Purchase(OfflinePlayer player, TicketTransaction ticket, AdvancedLottery plugin) {
        this.player = player;
        this.ticket = ticket;
        this.plugin = plugin;
    }

    public void executePurchase(boolean saveToDatabase, boolean deductMoney) {
        if (deductMoney) {
            this.executeMoneyTransaction();
        }
        this.registerTicket();
        if (this.plugin.getConfig().getBoolean("allow_broadcast")) {
            this.executeBroadcasts();
        }
        this.sendConfirmationMessage();
        this.addPlayerSkull();
        if (saveToDatabase) {
            this.savePurchaseToSqlDatabase();
        }
    }

    private void sendConfirmationMessage() {
        Player p = (Player)this.player;
        p.sendMessage(Messages.BUY_SUCCESS.getConfigValue(p).replaceAll("%balance%", SpigotCommons.formatMoney(this.plugin.getVaultEcon().getBalance(this.player))).replaceAll("%money%", SpigotCommons.formatMoney(this.ticket.getTotalPrice())).replaceAll("%time%", this.plugin.getLotteryTimer().time(false)).replaceAll("%time_short%", this.plugin.getLotteryTimer().time(true)).replaceAll("%ticket%", Integer.toString(this.ticket.getAmount())));
    }

    private void registerTicket() {
        this.plugin.getFileLogging().debug(String.format("%s bought %d tickets for %f", this.player.getName(), this.ticket.getAmount(), this.ticket.getTotalPrice()));
        LotteryTicket.getInstance(this.plugin).addPlayer(this.player, this.ticket.getAmount());
        LotteryPot.getInstance(this.plugin).addMoneyInPot(this.ticket.getTotalPrice());
    }

    private void executeMoneyTransaction() {
        this.plugin.getVaultEcon().takeMoney(this.ticket.getTotalPrice(), this.player);
    }

    private void addPlayerSkull() {
        LotteryGUI gui = LotteryGUI.getInstance();
        gui.addPlayer(this.player);
    }

    private void executeBroadcasts() {
        if (!this.player.isOnline()) {
            return;
        }
        Player p = (Player)this.player;
        ClickableText chat = new ClickableText();
        chat.sendToPlayer(p, this.ticket.getAmount());
    }

    private void savePurchaseToSqlDatabase() {
        LotterySql.getInstance(this.plugin).addMoney(this.player, this.ticket.getTotalPrice());
    }
}

