/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.tasks;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.gui.HelpGUI;
import com.gmail.ianlim224.advancedlottery.gui.LotteryGUI;
import com.gmail.ianlim224.advancedlottery.items.MenuItems;
import com.gmail.ianlim224.advancedlottery.object.LotteryPot;
import com.gmail.ianlim224.advancedlottery.utils.ItemBuilder;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import com.gmail.ianlim224.utils.XMaterial;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemTask
implements Runnable {
    private final AdvancedLottery plugin;
    private ItemStack pot;
    private ItemStack clock;
    private LotteryPot lotteryPot = LotteryPot.getInstance(AdvancedLottery.getInstance());
    private LotteryGUI lotteryInventory = LotteryGUI.getInstance();

    public ItemTask(AdvancedLottery plugin) {
        this.plugin = plugin;
        try {
            this.updatePotAndClock();
        }
        catch (Exception e) {
            System.out.println("---------------------------------");
            plugin.getLogger().warning("An error occurred when loading items.yml, resetting to default...");
            plugin.getLogger().warning("Please make sure that all material values are valid");
            System.out.println("---------------------------------");
            for (MenuItems i : MenuItems.values()) {
                MenuItems.getFc().set(i.getPath(), i.getDefaultListValue());
                MenuItems.loadConfigValues();
            }
            plugin.getItemsManager().saveConfig();
        }
    }

    @Override
    public void run() {
        this.updatePotAndClock();
        for (Inventory inv : this.lotteryInventory.getMenuInventory()) {
            inv.setItem(47, this.getPot());
            inv.setItem(51, this.getClock());
        }
        HelpGUI.getInstance(this.plugin).getInventory().setItem(39, this.getPot());
        HelpGUI.getInstance(this.plugin).getInventory().setItem(41, this.getClock());
    }

    public ItemStack getPot() {
        return this.pot;
    }

    private void setPot(ItemStack pot) {
        this.pot = pot;
    }

    public ItemStack getClock() {
        return this.clock;
    }

    private void setClock(ItemStack clock) {
        this.clock = clock;
    }

    private void updatePotAndClock() {
        this.setPot(new ItemBuilder(XMaterial.matchXMaterial(MenuItems.MONEY_POT_MATERIAL.getStringValue()).get().parseMaterial()).setName(MenuItems.MONEY_POT_NAME.getStringValue()).setLore(AdvancedLottery.replace(MenuItems.MONEY_POT_LORE.getListValue(), "%money%", SpigotCommons.formatMoney(this.lotteryPot.getMoneyInPot()))).toItemStack());
        this.setClock(new ItemBuilder(new ItemStack(XMaterial.matchXMaterial(MenuItems.TIME_PREVIEW_MATERIAL.getStringValue()).get().parseMaterial())).setName(MenuItems.TIME_PREVIEW_NAME.getStringValue()).setLore(MenuItems.TIME_PREVIEW_LORE.getStringValue().replaceAll("%time%", this.plugin.getLotteryTimer().time(false)).replaceAll("%time_short%", this.plugin.getLotteryTimer().time(true))).toItemStack());
    }
}

