/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.time;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import com.gmail.ianlim224.advancedlottery.fireworks.Fireworks;
import com.gmail.ianlim224.advancedlottery.gui.LotteryGUI;
import com.gmail.ianlim224.advancedlottery.messages.Messages;
import com.gmail.ianlim224.advancedlottery.mysql.LotterySql;
import com.gmail.ianlim224.advancedlottery.object.LotteryPot;
import com.gmail.ianlim224.advancedlottery.object.LotteryTicket;
import com.gmail.ianlim224.advancedlottery.sounds.WinSound;
import com.gmail.ianlim224.advancedlottery.time.Time;
import com.gmail.ianlim224.advancedlottery.utils.SpigotCommons;
import com.gmail.ianlim224.utils.messages.Titles;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class LotteryTimer {
    private final AdvancedLottery plugin;
    private final long duration;
    private long start;
    private long end;
    private BukkitTask task;

    public LotteryTimer(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.duration = TimeUnit.MINUTES.toMillis(plugin.getConfig().getInt("count_down_time"));
    }

    public void start() {
        this.start(this.duration);
    }

    public void start(long duration) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.start = System.currentTimeMillis();
        this.end = this.start + duration;
        this.task = new BukkitRunnable(){

            public void run() {
                LotteryTimer.this.end();
            }
        }.runTaskLater((Plugin)this.plugin, duration / 1000L * 20L);
        this.plugin.getReminderManager().reload();
    }

    public void end() {
        this.plugin.getFileLogging().debug("Ending lottery...");
        if (LotteryTicket.getInstance(this.plugin).isEmpty()) {
            this.plugin.getFileLogging().debug("There were no winners!");
            if (this.plugin.getConfig().getBoolean("allow_broadcast")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.sendMessage(Messages.BROADCAST_NO_WINNER.getConfigValue(p));
                }
            }
        } else {
            LotteryPot lotteryPot = LotteryPot.getInstance(this.plugin);
            double tax = this.plugin.getConfig().getDouble("lottery_tax_in_percentage");
            if (tax > 1.0) {
                tax = 0.0;
                this.plugin.getLogger().warning("Lottery tax can only range from 0 - 1");
            }
            if (LotteryTicket.getInstance(this.plugin).getPlayers().size() == 1) {
                tax = 0.0;
            }
            double prize = lotteryPot.getMoneyInPot() * (1.0 - tax);
            OfflinePlayer winner = Bukkit.getOfflinePlayer((UUID)LotteryTicket.getInstance(this.plugin).selectWinner());
            this.processWinner(winner, prize, this.plugin.getConfig().getBoolean("shoot_fireworks_on_win"));
            this.broadcastWin(winner, prize);
            this.updateWinnerData(winner);
        }
        this.cleanUp();
        this.setDuration(this.duration);
    }

    private void processWinner(OfflinePlayer winner, double prize, boolean fireworks) {
        this.plugin.getFileLogging().debug(String.format("%s won the lottery with a prize of %f", winner.getName(), prize));
        this.plugin.getVaultEcon().payMoney(prize, winner);
        if (winner.isOnline()) {
            Player player = Bukkit.getPlayer((UUID)winner.getUniqueId());
            if (fireworks) {
                Fireworks fw = new Fireworks();
                fw.shootFireworks(player, this.plugin);
            }
            new WinSound().playSound(player, this.plugin);
        }
        LotterySql.getInstance(this.plugin).addWins(winner);
        LotterySql.getInstance(this.plugin).addMoneyWon(winner, prize);
    }

    private void broadcastWin(OfflinePlayer winner, double prize) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(Messages.LOTTERY_WIN.getConfigValue(p).replaceAll("%player%", winner.getName()).replaceAll("%money%", SpigotCommons.formatMoney(prize)));
        }
        if (this.plugin.getConfig().getBoolean("play_out_title_when_win")) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                Titles.sendTitle(p, (int)(AdvancedLottery.getLotteryGrabber().getFadeInSeconds() * 20.0), (int)(AdvancedLottery.getLotteryGrabber().getStaySeconds() * 20.0), (int)(AdvancedLottery.getLotteryGrabber().getFadeOutSeconds() * 20.0), Messages.WINNER_TITLE_MESSAGE.getConfigValue(p).replaceAll("%player%", winner.getName()), Messages.WINNER_SUBTITLE_MESSAGE.getConfigValue(p).replaceAll("%money%", SpigotCommons.formatMoney(prize)));
            }
        }
    }

    private void updateWinnerData(OfflinePlayer winner) {
        this.plugin.getWinnerRegistry().setWinner(winner);
    }

    private void cleanUp() {
        LotteryTicket.getInstance(this.plugin).clear();
        LotteryGUI.getInstance().reset(this.plugin);
        LotteryPot.getInstance(this.plugin).clearMoneyInPot();
        this.plugin.getReminderManager().reload();
        LotterySql.getInstance(this.plugin).clearCache();
    }

    public long timeLeft() {
        return this.end - System.currentTimeMillis();
    }

    public String time(boolean isShort) {
        if (this.timeLeft() < 0L) {
            this.end();
        }
        return new Time(this.timeLeft(), isShort, this.plugin).toString();
    }

    public long getDuration() {
        return this.end - System.currentTimeMillis();
    }

    public void setDuration(long duration) {
        this.start(duration);
    }
}

