/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Cooldown {
    private final Map<UUID, Long> cache;
    private final long cooldownDuration;

    public Cooldown(Duration duration) {
        this.cooldownDuration = duration.toMillis();
        this.cache = new HashMap<UUID, Long>();
    }

    public void addCooldown(Player player) {
        this.cache.put(player.getUniqueId(), System.currentTimeMillis() + this.cooldownDuration);
    }

    public Duration getTimeLeft(Player player) {
        return Duration.ofMillis(this.cache.get(player.getUniqueId()) - System.currentTimeMillis());
    }

    public boolean isReady(Player player) {
        if (!this.cache.containsKey(player.getUniqueId())) {
            return true;
        }
        return System.currentTimeMillis() > this.cache.get(player.getUniqueId());
    }
}

