/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ianlim224.advancedlottery.utils;

import com.gmail.ianlim224.advancedlottery.AdvancedLottery;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class FileLogging {
    private static final long MAX_FILE_SIZE = 9000L;
    private final AdvancedLottery plugin;
    private final File logFile;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("[yyyy/MM/dd HH:mm:ss] ");

    public FileLogging(AdvancedLottery plugin) {
        this.plugin = plugin;
        this.logFile = new File(plugin.getDataFolder(), "/data/lottery.log");
    }

    public void debug(String msg) {
        String time = LocalDateTime.now().format(this.formatter);
        this.checkIfLogsFileExists();
        this.service.execute(() -> {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFile, true));){
                writer.write(time + " " + msg + "\n");
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to read from winner.dat!", e);
            }
        });
    }

    private void checkIfLogsFileExists() {
        this.checkIfLogExceeded();
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create lottery.log!", e);
            }
        }
    }

    private void checkIfLogExceeded() {
        if (this.logFile.exists() && this.logFile.getTotalSpace() > 9000L) {
            this.logFile.delete();
        }
    }
}

