/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.sql.SQLException;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.Version;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.GeneralCommand;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nexmedia.engine.command.list.ReloadSubCommand;
import su.nexmedia.engine.utils.EngineUtils;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.hologram.IHologramHandler;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.ArenaManager;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.setup.ArenaSetupManager;
import su.nightexpress.ama.command.EditorCommand;
import su.nightexpress.ama.command.ForceEndCommand;
import su.nightexpress.ama.command.ForceStartCommand;
import su.nightexpress.ama.command.JoinCommand;
import su.nightexpress.ama.command.LeaveCommand;
import su.nightexpress.ama.command.ListCmd;
import su.nightexpress.ama.command.RegionCommand;
import su.nightexpress.ama.command.ScoreCmd;
import su.nightexpress.ama.command.SetActiveCommand;
import su.nightexpress.ama.command.ShopCommand;
import su.nightexpress.ama.command.SkipRoundCommand;
import su.nightexpress.ama.command.SpectateCommand;
import su.nightexpress.ama.command.SpotCommand;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.currency.CurrencyManager;
import su.nightexpress.ama.data.DataHandler;
import su.nightexpress.ama.data.UserManager;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.editor.EditorHub;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.hologram.HologramManager;
import su.nightexpress.ama.hologram.handler.HologramDecentHandler;
import su.nightexpress.ama.hologram.handler.HologramDisplaysHandler;
import su.nightexpress.ama.hook.external.McMMOHook;
import su.nightexpress.ama.hook.external.PlaceholderHook;
import su.nightexpress.ama.hook.level.PluginLevelProvider;
import su.nightexpress.ama.hook.level.impl.MMOCorePlayerLevelProvider;
import su.nightexpress.ama.hook.mob.PluginMobProvider;
import su.nightexpress.ama.hook.mob.impl.BossManiaProvider;
import su.nightexpress.ama.hook.mob.impl.EliteMobsProvider;
import su.nightexpress.ama.hook.mob.impl.MythicMobProvider;
import su.nightexpress.ama.kit.KitManager;
import su.nightexpress.ama.mob.MobManager;
import su.nightexpress.ama.mob.style.MobStyleType;
import su.nightexpress.ama.nms.ArenaNMS;
import su.nightexpress.ama.nms.v1_18_R2.V1_18_R2;
import su.nightexpress.ama.nms.v1_19_R3.V1_19_R3;
import su.nightexpress.ama.nms.v1_20_R1.V1_20_R1;
import su.nightexpress.ama.sign.SignManager;
import su.nightexpress.ama.stats.StatsManager;
import su.nightexpress.ama.stats.object.StatType;

public class AMA
extends NexPlugin<AMA>
implements UserDataHolder<AMA, ArenaUser> {
    private DataHandler userData;
    private UserManager userManager;
    private CurrencyManager currencyManager;
    private ArenaManager arenaManager;
    private ArenaSetupManager arenaSetupManager;
    private MobManager mobManager;
    private KitManager kitManager;
    private StatsManager statsManager;
    private EditorHub editorHub;
    private SignManager signManager;
    private HologramManager hologramManager;
    private ArenaNMS arenaNMS;

    @NotNull
    protected AMA getSelf() {
        return this;
    }

    public void enable() {
        switch (Version.getCurrent()) {
            case V1_18_R2: {
                this.arenaNMS = new V1_18_R2();
                break;
            }
            case V1_19_R3: {
                this.arenaNMS = new V1_19_R3();
                break;
            }
            case V1_20_R1: {
                this.arenaNMS = new V1_20_R1();
                break;
            }
        }
        if (this.arenaNMS == null) {
            this.error("Could not setup NMS interface! (Unsupported server version)");
            this.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.currencyManager = new CurrencyManager(this);
        this.currencyManager.setup();
        if (!this.getCurrencyManager().hasCurrency()) {
            this.warn("No currencies are enabled/available! Cost features will not work.");
        }
        if (((Boolean)Config.HOLOGRAMS_ENABLED.get()).booleanValue()) {
            IHologramHandler<Hologram> iHologramHandler = null;
            if (EngineUtils.hasPlugin((String)"HolographicDisplays")) {
                iHologramHandler = new HologramDisplaysHandler();
            } else if (EngineUtils.hasPlugin((String)"DecentHolograms")) {
                iHologramHandler = new HologramDecentHandler();
            }
            if (iHologramHandler != null) {
                this.info("Found compatible holograms plugin! Let's use hologram features.");
                this.hologramManager = new HologramManager(this, iHologramHandler);
                this.hologramManager.setup();
            } else {
                this.warn("Can not found a compatible holograms plugin. Holograms feature will be disabled.");
            }
        }
        this.mobManager = new MobManager(this);
        this.mobManager.setup();
        this.kitManager = new KitManager(this);
        this.kitManager.setup();
        this.arenaManager = new ArenaManager(this);
        this.arenaManager.setup();
        this.arenaSetupManager = new ArenaSetupManager(this);
        this.arenaSetupManager.setup();
        this.statsManager = new StatsManager(this);
        this.statsManager.setup();
        if (((Boolean)Config.SIGNS_ENABLED.get()).booleanValue()) {
            this.signManager = new SignManager(this);
            this.signManager.setup();
        }
    }

    public void disable() {
        if (this.hologramManager != null) {
            this.hologramManager.shutdown();
            this.hologramManager = null;
        }
        if (this.editorHub != null) {
            this.editorHub.clear();
            this.editorHub = null;
        }
        if (this.arenaSetupManager != null) {
            this.arenaSetupManager.shutdown();
            this.arenaSetupManager = null;
        }
        if (this.arenaManager != null) {
            this.arenaManager.shutdown();
            this.arenaManager = null;
        }
        if (this.mobManager != null) {
            this.mobManager.shutdown();
            this.mobManager = null;
        }
        if (this.kitManager != null) {
            this.kitManager.shutdown();
            this.kitManager = null;
        }
        if (this.statsManager != null) {
            this.statsManager.shutdown();
            this.statsManager = null;
        }
        if (this.currencyManager != null) {
            this.currencyManager.shutdown();
            this.currencyManager = null;
        }
        if (this.signManager != null) {
            this.signManager.shutdown();
            this.signManager = null;
        }
        PluginLevelProvider.getProvidersMap().clear();
        PluginMobProvider.getProvidersMap().clear();
    }

    public void loadConfig() {
        this.getConfig().initializeOptions(Config.class);
    }

    public void loadLang() {
        this.getLangManager().loadMissing(Lang.class);
        this.getLangManager().loadEditor(EditorLocales.class);
        this.getLangManager().loadEnum(GameState.class);
        this.getLangManager().loadEnum(LockState.class);
        this.getLangManager().loadEnum(ArenaGameEventType.class);
        this.getLangManager().loadEnum(ArenaTargetType.class);
        this.getLangManager().loadEnum(StatType.class);
        this.getLangManager().loadEnum(HologramType.class);
        this.getLangManager().loadEnum(MobStyleType.class);
        this.getLang().saveChanges();
    }

    public void registerHooks() {
        if (EngineUtils.hasPlugin((String)"mcMMO")) {
            McMMOHook.setup();
        }
        if (EngineUtils.hasPlaceholderAPI()) {
            PlaceholderHook.setup();
        }
        if (EngineUtils.hasPlugin((String)"MMOCore")) {
            PluginLevelProvider.registerProvider(new MMOCorePlayerLevelProvider());
        }
        if (EngineUtils.hasPlugin((String)"MythicMobs")) {
            PluginMobProvider.registerProvider(new MythicMobProvider());
        }
        if (EngineUtils.hasPlugin((String)"EliteMobs")) {
            PluginMobProvider.registerProvider(new EliteMobsProvider());
        }
        if (EngineUtils.hasPlugin((String)"BossMania")) {
            PluginMobProvider.registerProvider(new BossManiaProvider());
        }
    }

    public void registerCommands(@NotNull GeneralCommand<AMA> generalCommand) {
        generalCommand.addChildren((AbstractCommand)new EditorCommand(this));
        generalCommand.addChildren((AbstractCommand)new ReloadSubCommand((NexPlugin)this, (Permission)Perms.COMMAND_RELOAD));
        generalCommand.addChildren((AbstractCommand)new ForceEndCommand(this));
        generalCommand.addChildren((AbstractCommand)new ForceStartCommand(this));
        generalCommand.addChildren((AbstractCommand)new JoinCommand(this));
        generalCommand.addChildren((AbstractCommand)new LeaveCommand(this));
        generalCommand.addChildren((AbstractCommand)new ListCmd(this));
        generalCommand.addChildren((AbstractCommand)new RegionCommand(this));
        generalCommand.addChildren((AbstractCommand)new SetActiveCommand(this));
        generalCommand.addChildren((AbstractCommand)new ScoreCmd(this));
        generalCommand.addChildren((AbstractCommand)new ShopCommand(this));
        generalCommand.addChildren((AbstractCommand)new SkipRoundCommand(this));
        generalCommand.addChildren((AbstractCommand)new SpectateCommand(this));
        generalCommand.addChildren((AbstractCommand)new SpotCommand(this));
    }

    public void registerPermissions() {
        this.registerPermissions(Perms.class);
    }

    public boolean setupDataHandlers() {
        try {
            this.userData = DataHandler.getInstance(this);
            this.userData.setup();
        }
        catch (SQLException sQLException) {
            this.error("Could not setup database handler!");
            sQLException.printStackTrace();
            return false;
        }
        this.userManager = new UserManager(this);
        this.userManager.setup();
        return true;
    }

    @NotNull
    public DataHandler getData() {
        return this.userData;
    }

    @NotNull
    public UserManager getUserManager() {
        return this.userManager;
    }

    @NotNull
    public EditorHub getEditor() {
        if (this.editorHub == null) {
            this.editorHub = new EditorHub(this);
        }
        return this.editorHub;
    }

    @NotNull
    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    @NotNull
    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    @NotNull
    public ArenaSetupManager getArenaSetupManager() {
        return this.arenaSetupManager;
    }

    @NotNull
    public MobManager getMobManager() {
        return this.mobManager;
    }

    @NotNull
    public KitManager getKitManager() {
        return this.kitManager;
    }

    @NotNull
    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    @Nullable
    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    @Nullable
    public SignManager getSignManager() {
        return this.signManager;
    }

    @NotNull
    public ArenaNMS getArenaNMS() {
        return this.arenaNMS;
    }
}

