/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.arena;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.hook.level.PlayerLevelProvider;
import su.nightexpress.ama.hook.level.PluginLevelProvider;

public class ArenaMainEditor
extends EditorMenu<AMA, ArenaConfig> {
    public ArenaMainEditor(@NotNull AMA aMA, @NotNull ArenaConfig arenaConfig) {
        super((NexPlugin)aMA, (Object)arenaConfig, "Arena Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> aMA.getEditor().getArenaEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.LIME_DYE, EditorLocales.ARENA_ACTIVE, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaConfig.setActive(!arenaConfig.isActive());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(arenaConfig.isActive() ? (!arenaConfig.hasProblems() ? Material.LIME_DYE : Material.PINK_DYE) : Material.GRAY_DYE));
        this.addItem(Material.NAME_TAG, EditorLocales.ARENA_NAME, new int[]{6}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            arenaConfig.setName(inputWrapper.getText());
            arenaConfig.save();
            return true;
        }));
        this.addItem(Material.DAYLIGHT_DETECTOR, EditorLocales.ARENA_AUTO_STATE_SCHEDULERS, new int[]{2}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    arenaConfig.getAutoOpenTimes().clear();
                } else {
                    arenaConfig.getAutoCloseTimes().clear();
                }
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), (Collection)CollectionsUtil.getEnumsList(DayOfWeek.class), (boolean)false);
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_ENTER_SCHEDULER_TIME, inputWrapper -> {
                LocalTime localTime;
                String[] stringArray = inputWrapper.getTextRaw().split(" ");
                if (stringArray.length < 2) {
                    return false;
                }
                DayOfWeek dayOfWeek2 = StringUtil.getEnum((String)stringArray[0], DayOfWeek.class).orElse(null);
                if (dayOfWeek2 == null) {
                    return false;
                }
                try {
                    localTime = LocalTime.parse(stringArray[1], ArenaUtils.TIME_FORMATTER);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    return false;
                }
                Map<DayOfWeek, Set<LocalTime>> map = inventoryClickEvent.isLeftClick() ? arenaConfig.getAutoOpenTimes() : arenaConfig.getAutoCloseTimes();
                map.computeIfAbsent(dayOfWeek2, dayOfWeek -> new HashSet()).add(localTime);
                arenaConfig.save();
                return true;
            });
        });
        this.addItem(Material.GOLDEN_AXE, EditorLocales.ARENA_SETUP_KIT, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> {
            aMA.getArenaSetupManager().getConfigSetupManager().startSetup(menuViewer.getPlayer(), arenaConfig);
            aMA.runTask(bukkitTask -> menuViewer.getPlayer().closeInventory());
        });
        this.addItem(Material.REDSTONE_TORCH, EditorLocales.ARENA_PERMISSION_REQUIREMENT, new int[]{10}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaConfig.setPermissionRequired(!arenaConfig.isPermissionRequired());
            this.save(menuViewer);
        });
        this.addItem(Material.GOLD_NUGGET, EditorLocales.ARENA_PAYMENT_REQUIREMENT, new int[]{16}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                arenaConfig.getJoinPaymentRequirements().clear();
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), aMA.getCurrencyManager().getCurrencyIds(), (boolean)false);
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_ENTER_JOIN_PAYMENT, inputWrapper -> {
                String[] stringArray = inputWrapper.getTextRaw().split(" ");
                if (stringArray.length < 2) {
                    return false;
                }
                Currency currency = aMA.getCurrencyManager().getCurrency(stringArray[0]);
                if (currency == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)aMA.getMessage(Lang.ERROR_CURRENCY_INVALID).getLocalized());
                    return false;
                }
                double d = StringUtil.getDouble((String)stringArray[1], (double)-1.0);
                if (d < 0.0) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)aMA.getMessage(Lang.EDITOR_ERROR_NUMBER_GENERIC).getLocalized());
                    return false;
                }
                arenaConfig.getJoinPaymentRequirements().put(currency, d);
                arenaConfig.save();
                return true;
            });
        });
        this.addItem(Material.ENCHANTING_TABLE, EditorLocales.ARENA_LEVEL_REQUIREMENT, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                arenaConfig.getJoinLevelRequirements().clear();
                this.save(menuViewer);
                return;
            }
            if (PluginLevelProvider.getProviders().isEmpty()) {
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), PluginLevelProvider.getProvidersMap().keySet(), (boolean)false);
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_ENTER_JOIN_LEVEL, inputWrapper -> {
                String[] stringArray = inputWrapper.getTextRaw().split(" ");
                if (stringArray.length < 2) {
                    return false;
                }
                PlayerLevelProvider playerLevelProvider = PluginLevelProvider.getProvider(stringArray[0]);
                if (playerLevelProvider == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)aMA.getMessage(Lang.EDITOR_ARENA_ERROR_LEVEL_PROVIDER).getLocalized());
                    return false;
                }
                int n = StringUtil.getInteger((String)stringArray[1], (int)-1);
                if (n < 0) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)aMA.getMessage(Lang.EDITOR_ERROR_NUMBER_GENERIC).getLocalized());
                    return false;
                }
                arenaConfig.getJoinLevelRequirements().put(playerLevelProvider, n);
                arenaConfig.save();
                return true;
            });
        });
        this.addItem(Material.EXPERIENCE_BOTTLE, EditorLocales.ARENA_GAMEPLAY_MANAGER, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> arenaConfig.getGameplayManager().getEditor().openNextTick(menuViewer, 1)).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getGameplayManager().replacePlaceholders()));
        this.addItem(Material.MAP, EditorLocales.ARENA_REGION_MANAGER, new int[]{22}).setClick((menuViewer, inventoryClickEvent) -> arenaConfig.getRegionManager().getEditor().openNextTick(menuViewer, 1)).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getRegionManager().replacePlaceholders()));
        this.addItem(Material.BLAZE_POWDER, EditorLocales.ARENA_WAVE_MANAGER, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> arenaConfig.getWaveManager().getEditor().openNextTick(menuViewer.getPlayer(), 1)).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getWaveManager().replacePlaceholders()));
        this.addItem(Material.GOLD_INGOT, EditorLocales.ARENA_REWARD_MANAGER, new int[]{30}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> arenaConfig.getRewardManager().getEditor().open(menuViewer.getPlayer(), 1))).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getRewardManager().replacePlaceholders()));
        this.addItem(Material.EMERALD, EditorLocales.ARENA_SHOP_MANAGER, new int[]{31}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> arenaConfig.getShopManager().getEditor().open(menuViewer.getPlayer(), 1))).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getShopManager().replacePlaceholders()));
        this.addItem(Material.COMPASS, EditorLocales.ARENA_SPOT_MANAGER, new int[]{32}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> arenaConfig.getSpotManager().getEditor().open(menuViewer.getPlayer(), 1))).getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.getSpotManager().replacePlaceholders()));
        this.addItem(Material.CHEST, EditorLocales.ARENA_SUPPLY_MANAGER, new int[]{34}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> arenaConfig.getSupplyManager().getEditor().open(menuViewer.getPlayer(), 1)));
        this.addItem(Material.CHAIN_COMMAND_BLOCK, EditorLocales.ARENA_SCRIPT_MANAGER, new int[]{28}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> arenaConfig.getScriptManager().getEditor().open(menuViewer.getPlayer(), 1)));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaConfig.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ArenaConfig)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }
}

