/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.region;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.region.ArenaRegionManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class RegionListEditor
extends EditorMenu<AMA, ArenaRegionManager>
implements AutoPaged<ArenaRegion> {
    public RegionListEditor(@NotNull ArenaRegionManager arenaRegionManager) {
        super((NexPlugin)arenaRegionManager.plugin(), (Object)arenaRegionManager, "Arena Region Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaRegionManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.REGION_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_REGION_ENTER_ID, inputWrapper -> {
            if (!arenaRegionManager.createRegion(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_REGION_ERROR_EXISTS).getLocalized());
                return false;
            }
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((RegionListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaRegion> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaRegion>(((ArenaRegionManager)this.object).getRegions());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaRegion arenaRegion) {
        ItemStack itemStack = new ItemStack(Material.OAK_FENCE);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.REGION_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.REGION_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaRegion.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaRegion arenaRegion) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                if (((ArenaRegionManager)this.object).removeRegion(arenaRegion)) {
                    this.openNextTick(menuViewer, menuViewer.getPage());
                }
                return;
            }
            arenaRegion.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

