/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.region;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class RegionMainEditor
extends EditorMenu<AMA, ArenaRegion> {
    public RegionMainEditor(@NotNull ArenaRegion arenaRegion) {
        super((NexPlugin)((AMA)arenaRegion.plugin()), (Object)arenaRegion, "Arena Region Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> arenaRegion.getArenaConfig().getRegionManager().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.LIME_DYE, EditorLocales.REGION_ACTIVE, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaRegion.setActive(!arenaRegion.isActive());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(arenaRegion.isActive() ? (!arenaRegion.hasProblems() ? Material.LIME_DYE : Material.PINK_DYE) : Material.GRAY_DYE));
        this.addItem(Material.NAME_TAG, EditorLocales.REGION_NAME, new int[]{20}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            arenaRegion.setName(inputWrapper.getTextColored());
            arenaRegion.save();
            return true;
        }));
        this.addItem(Material.GOLDEN_AXE, EditorLocales.REGION_SETUP_KIT, new int[]{22}).setClick((menuViewer, inventoryClickEvent) -> {
            if (arenaRegion.isActive()) {
                ((AMA)this.plugin).getMessage(Lang.Setup_Region_Error_Enabled).send((CommandSender)menuViewer.getPlayer());
                return;
            }
            ((AMA)this.plugin).runTask(bukkitTask -> menuViewer.getPlayer().closeInventory());
            ((AMA)this.plugin).getArenaSetupManager().getRegionSetupManager().startSetup(menuViewer.getPlayer(), arenaRegion);
        });
        this.addItem(Material.GRAY_TERRACOTTA, EditorLocales.REGION_DEFAULT, new int[]{24}).setClick((menuViewer, inventoryClickEvent) -> {
            ArenaRegion arenaRegion2 = arenaRegion.getArenaConfig().getRegionManager().getDefaultRegion();
            if (arenaRegion2 != null && !((ArenaRegion)this.object).equals(arenaRegion2)) {
                return;
            }
            arenaRegion.setDefault(!arenaRegion.isDefault());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(arenaRegion.isDefault() ? Material.LIME_TERRACOTTA : Material.GRAY_TERRACOTTA));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaRegion.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ArenaRegion)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }
}

