/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.script.condition.ScriptConditions;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ScriptConditionsEditor
extends EditorMenu<AMA, ArenaScript>
implements AutoPaged<String> {
    private final ScriptCategory category;

    public ScriptConditionsEditor(@NotNull ScriptCategory scriptCategory, @NotNull ArenaScript arenaScript) {
        super((NexPlugin)arenaScript.plugin(), (Object)arenaScript, "Arena Script Editor", 45);
        this.category = scriptCategory;
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> scriptCategory.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SCRIPT_CONDITION_SECTION_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_CONDITION_SECTION, inputWrapper -> {
            String string = StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw());
            if (arenaScript.getConditions().containsKey(string)) {
                return true;
            }
            arenaScript.getConditions().put(string, new ArrayList());
            scriptCategory.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ScriptConditionsEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<String> getObjects(@NotNull Player player) {
        return new ArrayList<String>(((ArenaScript)this.object).getConditions().keySet());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull String string2) {
        ItemStack itemStack = new ItemStack(Material.CHAIN_COMMAND_BLOCK);
        String string3 = ((ArenaScript)this.object).getConditions().getOrDefault(string2, Collections.emptyList()).stream().map(ScriptPreparedCondition::toRaw).map(string -> ChatColor.GREEN + string).collect(Collectors.joining("\n"));
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SCRIPT_CONDITION_SECTION_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SCRIPT_CONDITION_SECTION_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, string3 -> string3.replace("%script_condition_section_id%", string2).replace("%script_condition_section_conditions%", string3));
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull String string) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaScript)this.object).getConditions().remove(string);
                this.category.save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            Player player = menuViewer.getPlayer();
            if (inventoryClickEvent.isLeftClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), ScriptConditions.getConditions().stream().map(ScriptCondition::getName).toList(), (boolean)false);
                this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_CONDITION_VALUE, inputWrapper -> {
                    String[] stringArray = inputWrapper.getTextRaw().split(" ");
                    if (stringArray.length < 3) {
                        EditorManager.error((Player)player, (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SCRIPT_ERROR_INVALID_INPUT).getLocalized());
                        return false;
                    }
                    String string3 = stringArray[0];
                    String string4 = stringArray[1];
                    String string5 = stringArray[2];
                    ScriptCondition<?, ?> scriptCondition = ScriptConditions.getByName(string3);
                    if (scriptCondition == null) {
                        EditorManager.error((Player)player, (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SCRIPT_ERROR_INVALID_CONDITION).getLocalized());
                        return false;
                    }
                    Object obj = scriptCondition.getParser().apply(string5);
                    ScriptCondition.Operator operator = ScriptCondition.Operator.fromString(string4).orElse(ScriptCondition.Operator.EQUAL);
                    ((ArenaScript)this.object).getConditions().computeIfAbsent(string, string -> new ArrayList()).add(new ScriptPreparedCondition(scriptCondition, obj, operator));
                    this.category.save();
                    return true;
                });
                return;
            }
            if (inventoryClickEvent.isRightClick()) {
                ((ArenaScript)this.object).getConditions().computeIfAbsent(string, string -> new ArrayList()).clear();
                this.category.save();
                this.openNextTick(menuViewer, menuViewer.getPage());
            }
        };
    }
}

