/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.script;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.script.ArenaScriptManager;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ScriptsEditor
extends EditorMenu<AMA, ArenaScriptManager>
implements AutoPaged<ScriptCategory> {
    public ScriptsEditor(@NotNull ArenaScriptManager arenaScriptManager) {
        super((NexPlugin)arenaScriptManager.plugin(), (Object)arenaScriptManager, "Arena Script Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaScriptManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SCRIPT_CATEGORY_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_CATEGORY, inputWrapper -> {
            arenaScriptManager.createCategory(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()));
            arenaScriptManager.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ScriptsEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ScriptCategory> getObjects(@NotNull Player player) {
        return new ArrayList<ScriptCategory>(((ArenaScriptManager)this.object).getCategories());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ScriptCategory scriptCategory) {
        ItemStack itemStack = new ItemStack(Material.COMMAND_BLOCK_MINECART);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SCRIPT_CATEGORY_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SCRIPT_CATEGORY_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, string -> string.replace("%script_category_id%", scriptCategory.getId()));
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ScriptCategory scriptCategory) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaScriptManager)this.object).deleteCategory(scriptCategory);
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            scriptCategory.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

