/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.spot;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.editor.spot.SpotStatesEditor;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class SpotSettingsEditor
extends EditorMenu<AMA, ArenaSpot> {
    private SpotStatesEditor spotStatesEditor;

    public SpotSettingsEditor(@NotNull ArenaSpot arenaSpot) {
        super((NexPlugin)((AMA)arenaSpot.plugin()), (Object)arenaSpot, "Arena Spot Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> arenaSpot.getArenaConfig().getSpotManager().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.LIME_DYE, EditorLocales.SPOT_ACTIVE, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaSpot.setActive(!arenaSpot.isActive());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(arenaSpot.isActive() ? (!arenaSpot.hasProblems() ? Material.LIME_DYE : Material.PINK_DYE) : Material.GRAY_DYE));
        this.addItem(Material.NAME_TAG, EditorLocales.SPOT_NAME, new int[]{20}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            arenaSpot.setName(inputWrapper.getText());
            arenaSpot.save();
            return true;
        }));
        this.addItem(Material.GOLDEN_AXE, EditorLocales.SPOT_SETUP_KIT, new int[]{22}).setClick((menuViewer, inventoryClickEvent) -> {
            ((AMA)this.plugin).runTask(bukkitTask -> menuViewer.getPlayer().closeInventory());
            ((AMA)this.plugin).getArenaSetupManager().getSpotSetupManager().startSetup(menuViewer.getPlayer(), arenaSpot);
        });
        this.addItem(Material.ITEM_FRAME, EditorLocales.SPOT_STATES, new int[]{24}).setClick((menuViewer, inventoryClickEvent) -> {
            if (arenaSpot.getCuboid().isEmpty()) {
                ((AMA)this.plugin).getMessage(Lang.EDITOR_SPOT_STATE_ERROR_NO_CUBOID).send((CommandSender)menuViewer.getPlayer());
                return;
            }
            this.getStatesEditor().openNextTick(menuViewer, 1);
        });
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaSpot.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ArenaSpot)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    public void clear() {
        if (this.spotStatesEditor != null) {
            this.spotStatesEditor.clear();
            this.spotStatesEditor = null;
        }
        super.clear();
    }

    @NotNull
    public SpotStatesEditor getStatesEditor() {
        if (this.spotStatesEditor == null) {
            this.spotStatesEditor = new SpotStatesEditor((ArenaSpot)this.object);
        }
        return this.spotStatesEditor;
    }
}

