/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.wave;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.wave.ArenaWave;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.hook.mob.MobProvider;
import su.nightexpress.ama.hook.mob.PluginMobProvider;

public class WaveMobsEditor
extends EditorMenu<AMA, ArenaWave>
implements AutoPaged<ArenaWaveMob> {
    public WaveMobsEditor(@NotNull ArenaWave arenaWave) {
        super((NexPlugin)arenaWave.getArena().plugin(), (Object)arenaWave, "Arena Wave Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaWave.getArenaConfig().getWaveManager().getEditor().getListEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.WAVES_WAVE_MOB_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> {
            MobProvider mobProvider = PluginMobProvider.getProviders().stream().findFirst().orElseThrow();
            ArenaWaveMob arenaWaveMob = new ArenaWaveMob(arenaWave, mobProvider, "null", 1, 1, 100.0);
            arenaWave.getMobs().add(arenaWaveMob);
            arenaWave.getArenaConfig().getWaveManager().save();
            this.openNextTick(menuViewer, menuViewer.getPage());
        });
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((WaveMobsEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaWaveMob> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaWaveMob>(((ArenaWave)this.object).getMobs());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaWaveMob arenaWaveMob) {
        ItemStack itemStack = new ItemStack(Material.ZOMBIE_HEAD);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.WAVES_WAVE_MOB_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.WAVES_WAVE_MOB_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaWaveMob.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaWaveMob arenaWaveMob) {
        return (menuViewer, inventoryClickEvent) -> {
            Player player = menuViewer.getPlayer();
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaWave)this.object).getMobs().remove(arenaWaveMob);
                ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                this.openNextTick(player, menuViewer.getPage());
                return;
            }
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NUMBER, inputWrapper -> {
                        arenaWaveMob.setLevel(inputWrapper.asInt(1));
                        ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                        return true;
                    });
                }
            } else if (inventoryClickEvent.isLeftClick()) {
                EditorManager.suggestValues((Player)player, arenaWaveMob.getProvider().getMobNames(), (boolean)true);
                this.handleInput(menuViewer, Lang.EDITOR_ARENA_WAVES_ENTER_MOB_ID, inputWrapper -> {
                    if (!arenaWaveMob.getProvider().getMobNames().contains(inputWrapper.getTextRaw())) {
                        EditorManager.error((Player)player, (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_WAVES_ERROR_MOB_INVALID).getLocalized());
                        return false;
                    }
                    arenaWaveMob.setMobId(inputWrapper.getTextRaw());
                    ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                    return true;
                });
            } else if (inventoryClickEvent.isRightClick()) {
                this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NUMBER, inputWrapper -> {
                    arenaWaveMob.setAmount(inputWrapper.asInt(1));
                    ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                    return true;
                });
            } else if (inventoryClickEvent.getClick() == ClickType.DROP) {
                this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_PERCENT, inputWrapper -> {
                    arenaWaveMob.setChance(inputWrapper.asAnyDouble(0.0));
                    ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                    return true;
                });
            } else {
                if (inventoryClickEvent.getClick() == ClickType.SWAP_OFFHAND) {
                    ArrayList<MobProvider> arrayList = new ArrayList<MobProvider>(PluginMobProvider.getProviders());
                    arenaWaveMob.setProvider((MobProvider)CollectionsUtil.shifted(arrayList, (int)arrayList.indexOf(arenaWaveMob.getProvider()), (int)1));
                    ((ArenaWave)this.object).getArenaConfig().getWaveManager().save();
                    this.openNextTick(menuViewer, menuViewer.getPage());
                    return;
                }
                return;
            }
            player.closeInventory();
        };
    }
}

