/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.wave;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.wave.ArenaWaveManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class WavesGradualSettingsEditor
extends EditorMenu<AMA, ArenaWaveManager> {
    public WavesGradualSettingsEditor(@NotNull ArenaWaveManager arenaWaveManager) {
        super((NexPlugin)arenaWaveManager.getArena().plugin(), (Object)arenaWaveManager, "Arena Wave Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> arenaWaveManager.getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.LIME_DYE, EditorLocales.WAVES_GRADUAL_ENABLED, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            arenaWaveManager.setGradualSpawnEnabled(!arenaWaveManager.isGradualSpawnEnabled());
            arenaWaveManager.save();
            this.openNextTick(menuViewer, menuViewer.getPage());
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(arenaWaveManager.isGradualSpawnEnabled() ? Material.LIME_DYE : Material.GRAY_DYE));
        this.addItem(Material.MELON_SEEDS, EditorLocales.WAVES_GRADUAL_FIRST_PERCENT, new int[]{19}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_PERCENT, inputWrapper -> {
            arenaWaveManager.setGradualSpawnPercentFirst(inputWrapper.asInt());
            arenaWaveManager.save();
            return true;
        }));
        this.addItem(Material.PUMPKIN_SEEDS, EditorLocales.WAVES_GRADUAL_NEXT_PERCENT, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_PERCENT, inputWrapper -> {
            arenaWaveManager.setGradualSpawnNextPercent(inputWrapper.asInt());
            arenaWaveManager.save();
            return true;
        }));
        this.addItem(Material.CLOCK, EditorLocales.WAVES_GRADUAL_NEXT_INTERVAL, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_SECONDS, inputWrapper -> {
            arenaWaveManager.setGradualSpawnNextInterval(inputWrapper.asInt());
            arenaWaveManager.save();
            return true;
        }));
        this.addItem(Material.ROTTEN_FLESH, EditorLocales.WAVES_GRADUAL_NEXT_KILL_PERCENT, new int[]{25}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_PERCENT, inputWrapper -> {
            arenaWaveManager.setGradualSpawnNextKillPercent(inputWrapper.asInt());
            arenaWaveManager.save();
            return true;
        }));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaWaveManager.replacePlaceholders())));
    }
}

