/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;

public class ArenaUpcomingWave {
    private final List<ArenaWaveMob> mobs;
    private final List<Location> spawners;

    public ArenaUpcomingWave(@NotNull ArenaRegion arenaRegion, @NotNull List<ArenaWaveMob> list, @NotNull List<String> list2) {
        this.mobs = list;
        this.spawners = new ArrayList<Location>();
        list2.forEach(string -> {
            Location location = arenaRegion.getMobSpawner((String)string);
            if (location != null) {
                this.spawners.add(location);
            }
        });
        if (this.spawners.isEmpty() || list2.contains("*")) {
            this.spawners.addAll(arenaRegion.getMobSpawners().values());
        }
        Collections.shuffle(this.spawners);
    }

    public boolean isAllMobsSpawned() {
        return this.getPreparedMobs().stream().allMatch(arenaWaveMob -> arenaWaveMob.getAmount() <= 0);
    }

    public int getMobsAmount() {
        return this.getPreparedMobs().stream().mapToInt(ArenaWaveMob::getAmount).sum();
    }

    @NotNull
    public List<ArenaWaveMob> getPreparedMobs() {
        return this.mobs;
    }

    @NotNull
    public List<Location> getPreparedSpawners() {
        return this.spawners;
    }
}

