/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.listener;

import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractListener;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.mob.config.MobsConfig;

public class ArenaMythicListener
extends AbstractListener<AMA> {
    public ArenaMythicListener(@NotNull AMA aMA) {
        super((NexPlugin)aMA);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMythicSpawn(MythicMobSpawnEvent mythicMobSpawnEvent) {
        Entity entity = mythicMobSpawnEvent.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        entity = livingEntity.getLocation();
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaAtLocation((Location)entity);
        if (arena == null || !arena.getConfig().isActive()) {
            return;
        }
        if (arena.getState() == GameState.INGAME && !arena.isAboutToEnd()) {
            if (((Set)MobsConfig.ALLY_MYTHIC_MOBS.get()).contains(mythicMobSpawnEvent.getMobType().getInternalName())) {
                if (arena.getMobs().getEnemies().remove(livingEntity)) {
                    arena.setRoundTotalMobsAmount(arena.getRoundTotalMobsAmount() - 1);
                }
                arena.getMobs().getAllies().add(livingEntity);
            }
        } else {
            mythicMobSpawnEvent.setCancelled();
            livingEntity.remove();
        }
    }
}

