/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.region;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.arena.editor.region.RegionListEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.lock.Lockable;
import su.nightexpress.ama.arena.region.ArenaRegion;

public class ArenaRegionManager
implements ArenaChild,
Loadable,
Problematic,
Placeholder {
    public static final String DIR_REGIONS = "/regions/";
    private final ArenaConfig arenaConfig;
    private final Map<String, ArenaRegion> regions;
    private final PlaceholderMap placeholderMap;
    private RegionListEditor editor;

    public ArenaRegionManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.regions = new HashMap<String, ArenaRegion>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems()));
    }

    public void setup() {
        for (JYML jYML : JYML.loadAll((String)this.getRegionsPath(), (boolean)false)) {
            ArenaRegion arenaRegion = new ArenaRegion(this.getArenaConfig(), jYML);
            if (arenaRegion.load()) {
                this.addRegion(arenaRegion);
                continue;
            }
            this.plugin().error("Region not loaded '" + jYML.getFile().getName() + "' in '" + this.getArenaConfig().getFile().getName() + "' arena!");
        }
        this.getProblems().forEach(string -> this.plugin().warn("Problem in '" + this.getArenaConfig().getId() + "' arena Region Manager: " + string));
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getRegions().forEach(ArenaRegion::clear);
        this.getRegions().clear();
    }

    public void save() {
        this.getRegions().forEach(ConfigHolder::save);
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getRegionsMap().isEmpty()) {
            arrayList.add(this.problem("No Regions Created!"));
        }
        if (this.getDefaultRegion() == null) {
            arrayList.add(this.problem("No Default Region!"));
        } else if (!this.getDefaultRegion().isActive()) {
            arrayList.add(this.problem("Default Region is Inactive!"));
        }
        for (ArenaRegion arenaRegion : this.getRegions()) {
            if (!arenaRegion.isActive() || !arenaRegion.hasProblems()) continue;
            arrayList.add(this.problem("Problems with " + arenaRegion.getId() + " region!"));
        }
        return arrayList;
    }

    @NotNull
    public RegionListEditor getEditor() {
        if (this.editor == null) {
            this.editor = new RegionListEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public String getRegionsPath() {
        return this.arenaConfig.getFile().getParentFile().getAbsolutePath() + DIR_REGIONS;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public Map<String, ArenaRegion> getRegionsMap() {
        return this.regions;
    }

    @NotNull
    public Collection<ArenaRegion> getRegions() {
        return this.getRegionsMap().values();
    }

    @Nullable
    public ArenaRegion getDefaultRegion() {
        return this.getRegions().stream().filter(ArenaRegion::isDefault).findFirst().orElse(null);
    }

    @Nullable
    public ArenaRegion getFirstUnlocked() {
        return this.getRegions().stream().filter(ArenaRegion::isActive).filter(Lockable::isUnlocked).findFirst().orElse(null);
    }

    @Nullable
    public ArenaRegion getRegion(@NotNull String string) {
        return this.getRegionsMap().get(string.toLowerCase());
    }

    @Nullable
    public ArenaRegion getRegion(@NotNull Location location) {
        return this.getRegions().stream().filter(arenaRegion -> arenaRegion.getCuboid().isPresent() && arenaRegion.getCuboid().get().contains(location)).findFirst().orElse(null);
    }

    public void addRegion(@NotNull ArenaRegion arenaRegion) {
        this.getRegionsMap().put(arenaRegion.getId(), arenaRegion);
    }

    public boolean createRegion(@NotNull String string) {
        if (this.getRegion(string) != null) {
            return false;
        }
        JYML jYML = new JYML(this.getRegionsPath(), string + ".yml");
        ArenaRegion arenaRegion = new ArenaRegion(this.getArenaConfig(), jYML);
        arenaRegion.setActive(false);
        arenaRegion.setDefault(this.getRegions().isEmpty());
        arenaRegion.setName(StringUtil.capitalizeUnderscored((String)arenaRegion.getId()) + " Region");
        arenaRegion.setSpawnLocation(null);
        arenaRegion.save();
        arenaRegion.load();
        this.addRegion(arenaRegion);
        return true;
    }

    public boolean removeRegion(@NotNull ArenaRegion arenaRegion) {
        if (arenaRegion.getFile().delete()) {
            arenaRegion.clear();
            this.getRegionsMap().remove(arenaRegion.getId());
            return true;
        }
        return false;
    }
}

