/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.reward;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.editor.reward.RewardSettingsEditor;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.config.Lang;

public class ArenaReward
implements ArenaChild,
Placeholder {
    private final String id;
    private final ArenaConfig arenaConfig;
    private final PlaceholderMap placeholderMap;
    private String name;
    private boolean isLate;
    private List<String> commands;
    private List<ItemStack> items;
    private RewardSettingsEditor editor;

    public ArenaReward(@NotNull ArenaConfig arenaConfig, @NotNull String string) {
        this(arenaConfig, string, StringUtil.capitalizeUnderscored((String)string), true, new ArrayList<String>(), new ArrayList<ItemStack>());
    }

    public ArenaReward(@NotNull ArenaConfig arenaConfig, @NotNull String string, @NotNull String string2, boolean bl, @NotNull List<String> list, @NotNull List<ItemStack> list2) {
        this.id = string.toLowerCase();
        this.arenaConfig = arenaConfig;
        this.setName(string2);
        this.setLate(bl);
        this.setCommands(list);
        this.setItems(list2);
        this.placeholderMap = new PlaceholderMap().add("%reward_id%", this::getId).add("%reward_name%", this::getName).add("%reward_is_late%", () -> LangManager.getBoolean((boolean)this.isLate())).add("%reward_commands%", () -> String.join((CharSequence)"\n", this.getCommands()));
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public RewardSettingsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new RewardSettingsEditor(this);
        }
        return this.editor;
    }

    public void give(@NotNull Arena arena, ArenaTargetType arenaTargetType) {
        arena.getPlayers(arenaTargetType, PlayerType.REAL).forEach(arenaPlayer -> {
            if (this.isLate()) {
                arenaPlayer.getRewards().add(this);
            } else {
                this.give(arenaPlayer.getPlayer());
            }
            this.plugin().getMessage(Lang.ARENA_GAME_NOTIFY_REWARD).replace(this.replacePlaceholders()).send((CommandSender)arenaPlayer.getPlayer());
        });
    }

    public void give(@NotNull Player player) {
        this.getItems().forEach(itemStack -> PlayerUtil.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack}));
        this.getCommands().forEach(string -> PlayerUtil.dispatchCommand((Player)player, (String)string));
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    public boolean isLate() {
        return this.isLate;
    }

    public void setLate(boolean bl) {
        this.isLate = bl;
    }

    @NotNull
    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(@NotNull List<String> list) {
        this.commands = new ArrayList<String>(list);
    }

    @NotNull
    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(@NotNull List<ItemStack> list) {
        this.items = new ArrayList<ItemStack>(list);
        this.getItems().removeIf(itemStack -> itemStack == null || itemStack.getType().isAir());
    }
}

